//
//  QGMallHomeGoodsListViewController.m
//  VirtualPayment
//
//  Created by silicn on 2020/3/16.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallHomeGoodsListViewController.h"

@interface QGMallHomeGoodsListViewController ()

@end


@implementation QGMallHomeGoodsListViewController

- (BOOL)checkParameters:(NSDictionary *)param
{
    NSString *materialId = param[@"materialId"];
    if (!self.materialId) {
        self.materialId = materialId;
    }
    
    NSString *term = param[@"term"];
    if (!self.searchTerm) {
        self.searchTerm = term;
    }
    
    if (self.materialId || self.searchTerm) {
        return YES;
    }
    
    return NO;
}

- (void)transferParameters:(NSDictionary *)param
{
    NSString *title = param[@"title"];
    self.navTitle = title;
    
    NSString *leverOneName = param[@"levelName"];
    if (!self.levelOneName) {
        self.levelOneName = leverOneName;
    }
    
    self.isLevelTwo = [param[@"isLevelTwo"] boolValue];
}


- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self initNomalUI];
    
    // Do any additional setup after loading the view.
}


- (void)initNomalUI
{
    /// 增加刷新操作
    @weakify(self);
    [self.tableView addRefreshWithHandle:^(BOOL isHeaderRefresh) {
        @strongify(self);
        [self requestDataReload:isHeaderRefresh];
        if (isHeaderRefresh) {
            [self reloadMaterialView];
        }
    }];
    [self.tableView beginRefresh];
    
    /// 增加排序项
    QGMallSearchSectionItem *item1 = [[QGMallSearchSectionItem alloc]init];
    item1.title = @"综合";
    item1.sortAble = NO;
         
    QGMallSearchSectionItem *item2 = [[QGMallSearchSectionItem alloc]init];
    item2.title = @"券后价";
    item2.sortAble = YES;
         
         
    QGMallSearchSectionItem *item3 = [[QGMallSearchSectionItem alloc]init];
    item3.title = @"销量";
    item3.sortAble = YES;
    item3.downToUp = YES;
         
    self.sectionView.layoutEnable = YES;
    self.sectionView.items = @[item1,item2,item3];
    
    
}

- (void)requestDataReload:(BOOL)isReload
{
//    http://yapi.quantgroups.com/mock/305/app/mall/search
    if (isReload) {
        self.tableView.pageNum = 1;
    }
    
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
    NSMutableDictionary *param = [NSMutableDictionary dictionary];
    
    if (self.searchTerm) {
        [param setObject:self.searchTerm forKey:@"term"];
    }
    [param setObject:self.materialId ? self.materialId :@"" forKey:@"materialId"];
    [param setObject:@(self.orderType) forKey:@"orderType"];
    [param setObject:@(self.tableView.pageNum) forKey:@"currentPageNo"];
    [param setObject:@(self.tableView.pageCount) forKey:@"pageSize"];
    
    [networking GET:[QGMallRequestApi urlWithIndex:QGMallRequestServerMethodSearch] parameters:param success:^(id  _Nonnull responseObject) {
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary *dic = responseObject[@"data"];
            NSArray *list = dic[@"goodsList"];
            BOOL hasNext =  [dic[@"hasNext"] boolValue];
            if (isReload) {
                [self.dataSource removeAllObjects];
            }
            for (NSDictionary *dictionary in list) {
                QGMallBaseGoodsModel *model = [QGMallBaseGoodsModel yy_modelWithDictionary:dictionary];
                if (model) {
                     [self.dataSource addObject:model];
                }
            }
            [self.tableView reloadData];
            
            [self.tableView endRefreshWithBusinessSuccess:YES hasNext:hasNext];
            
        }else{
            [self.tableView endRefreshWithBusinessSuccess:NO hasNext:YES];
        }
        
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [self networkErrorPageWithPageNum:self.tableView.pageNum responseObject:nil error:error];
    }];
}

/// 布局排序项
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    return self.sectionView;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 45;
}

- (void)goToGoodsDetail:(QGMallBaseGoodsModel *)goodsModel
{
    [super goToGoodsDetail:goodsModel];
    [self trackWithModel:goodsModel];
}

- (void)trackWithModel:(QGMallBaseGoodsModel *)model
{
    NSString *page = self.searchTerm;
    if (self.isLevelTwo) {
        page  = [NSString stringWithFormat:@"%@-%@",self.levelOneName,page];
    }
    QGAppCoreModelClickEvent *event = [QGAppCoreModelClickEvent acmcEventWithPage:page path:@"商品列表" name:@"浏览商品列表" detail_name:model.goodsId acmc_model_other:model.goodsName];
    [QGAnalyticsService analyticsTrackWithEvent:event];
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
