//
//  QGMallGuessLikeViewController.m
//  VirtualPayment
//
//  Created by silicn on 2020/3/16.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallGuessLikeViewController.h"
#import <AdSupport/AdSupport.h>

@interface QGMallGuessLikeViewController ()

@end

@implementation QGMallGuessLikeViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self initNomalUI];
    // Do any additional setup after loading the view.
}

- (void)initNomalUI
{
    /// 增加刷新操作
    @weakify(self);
    [self.tableView addRefreshWithHandle:^(BOOL isHeaderRefresh) {
        @strongify(self);
        [self requestDataReload:isHeaderRefresh];
    }];
    [self.tableView beginRefresh];
    
    self.isBox = YES;
    
}

- (void)requestDataReload:(BOOL)isReload
{
//    http://yapi.quantgroups.com/mock/305/app/mall/search
    if (isReload) {
        self.tableView.pageNum = 1;
    }
    
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
    NSMutableDictionary *param = [NSMutableDictionary dictionary];
    
    [param setObject:@(self.tableView.pageNum) forKey:@"currentPageNo"];
    [param setObject:@(self.tableView.pageCount) forKey:@"pageSize"];
    
    NSMutableDictionary *headers = [NSMutableDictionary dictionaryWithCapacity:3];
    [headers setObject:@"MD5" forKey:@"deviceEncrypt"];
    NSString *idfa = [[ASIdentifierManager sharedManager] advertisingIdentifier].UUIDString;
    if (idfa) {
        [headers setObject:[idfa md5] forKey:@"deviceValue"];
    }
    [headers setObject:@"IDFA" forKey:@"deviceType"];
   
    
    [networking GET:[QGMallRequestApi urlWithIndex:QGMallRequestServerMethodRecently] headers:headers  parameters:param success:^(id  _Nonnull responseObject) {
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary *dic = responseObject[@"data"];
            NSArray *list = dic[@"goodsList"];
            BOOL hasNext =  [dic[@"hasNext"] boolValue];
            if (isReload) {
                [self.dataSource removeAllObjects];
            }
            for (NSDictionary *dictionary in list) {
                QGMallBaseGoodsModel *model = [QGMallBaseGoodsModel yy_modelWithDictionary:dictionary];
                if (model) {
                    [self.dataSource addObject:model];
                 }
            }
            [self.tableView reloadData];
            
            [self.tableView endRefreshWithBusinessSuccess:YES hasNext:hasNext];
            
        }else{
            [self.tableView endRefreshWithBusinessSuccess:NO hasNext:YES];
        }
        
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [self networkErrorPageWithPageNum:self.tableView.pageNum responseObject:nil error:error];
    }];
}

- (void)goToGoodsDetail:(QGMallBaseGoodsModel *)goodsModel
{
    [super goToGoodsDetail:goodsModel];
    [self trackWithModel:goodsModel];
}

- (void)trackWithModel:(QGMallBaseGoodsModel *)model
{
    QGAppCoreModelClickEvent *event = [QGAppCoreModelClickEvent acmcEventWithPage:@"猜你喜欢" path:@"商品列表" name:@"浏览商品列表" detail_name:model.goodsId acmc_model_other:model.goodsName];
    [QGAnalyticsService analyticsTrackWithEvent:event];
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
