//
//  QGMallGoodsListViewController.h
//  VirtualPayment
//
//  Created by silicn on 2020/3/11.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGBaseViewController.h"
#import "QGMallSearchSectionView.h"
#import "QGMallMaterialView.h"
#import "QGMallRequestApi.h"
#import "QGMallBaseGoodsModel.h"
#import "NSObject+YYModel.h"

@class QGMallMenuModel;

NS_ASSUME_NONNULL_BEGIN

/*
 所有商品列表的父类
 包含TableView
 二级目录levelTwoMaterialView
 排序视图sectionView
 默认是否网格布
 */

@interface QGMallGoodsListViewController : QGBaseViewController


#pragma mark - properties

/// 导航的标题title,没有默认显示searchTerm
@property (nonatomic, copy)NSString *navTitle;

/// 是否是子控制器
@property (nonatomic, assign)BOOL isChildren;

///categoryLevelOne:一级栏目(母婴,儿童,女装等)
///categoryLevelTwo:二级栏目(儿童,辅食,尿裤等)

/// 栏目Id
@property (nonatomic, copy) NSString *materialId ;

/// 商品类别名称,默认的导航Title
@property (nonatomic, copy)NSString *searchTerm;

/// 二级栏目项目,nil代表没有这个视图
@property (nonatomic, copy)NSArray<QGMallMaterialItem *> *categoryLevelTwoItmes;

/// 布局方式,是否是网格布局,默认不是网格布局:isBox = NO
@property (nonatomic, assign) BOOL isBox;

/// 数据源,默认初始化
@property (nonatomic, strong)NSMutableArray *dataSource;

///加载的TableView,默认pageNum = 1 pageCount = 20
@property (nonatomic, strong,readonly)UITableView *tableView;
/// 排序项视图,如果视图的items是空的,则表示sectionView存在,是空视图
@property (nonatomic, strong,readonly) QGMallSearchSectionView *sectionView;
/// 二级栏目项视图
@property (nonatomic, strong,readonly)  QGMallMaterialView *levelTwoMaterialView ;

/// 统一的排序类型
/// 排序项，1综合排序，2券后价升序，3券后价降序，4销量升序，5销量降序
@property (nonatomic, assign,readonly)NSInteger orderType;

#pragma mark - Methods

/// 网络错误页展示
/// @param pageNum 根据页码区分展示样式
/// @param responseObject 请求成功业务处理失败回调
/// @param error 请求失败错误信息
- (void)networkErrorPageWithPageNum:(NSInteger)pageNum responseObject:(nullable NSDictionary *)responseObject error:(nullable NSError *)error;

/// 去商品详情页
- (void)goToGoodsDetail:(QGMallBaseGoodsModel *)goodsModel;

/// 刷新二级栏目
- (void)reloadMaterialView;

@end

NS_ASSUME_NONNULL_END
