//
//  QGBestSellersViewController.m
//  VirtualPayment
//
//  Created by silicn on 2020/2/27.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGBestSellersViewController.h"


@interface QGBestSellersViewController ()

@end

@implementation QGBestSellersViewController

- (BOOL)checkParameters:(NSDictionary *)param
{
    return YES;
}

- (void)transferParameters:(NSDictionary *)param
{
    NSString * navTitle = param[@"title"];
    if (![NSString isEmpty:navTitle]) {
        self.navTitle = navTitle;
    }
    NSString *materialId = param[@"materialId"];
    if (materialId) {
        self.materialId = materialId;
    }
}

- (void)viewDidLoad {
    [super viewDidLoad];
    [self initNormalUI];

    
    // Do any additional setup after loading the view.
}

- (void)initNormalUI
{
    [self custemLeftDefaultBarButtonItem];
    if (self.navTitle) {
        self.title = self.navTitle;
    }else{
        self.title = @"今日热销";
    }
    //添加下拉刷新
    @weakify(self);
    [self.tableView addRefreshWithHandle:^(BOOL isHeaderRefresh) {
        @strongify(self);
        [self requestDataHeaderRefresh:isHeaderRefresh];
    }];
    [self.tableView beginRefresh];
    
    self.isBox = NO;
}

#pragma mark - Request

- (void)requestDataHeaderRefresh:(BOOL)isHeader
{
    if (isHeader) {
        self.tableView.pageNum = 1;
    }
    NSString *  url = [QGMallRequestApi urlWithIndex:QGMallRequestServerMethodBestSeller];
    //页码信息
    NSMutableDictionary * params = [NSMutableDictionary dictionaryWithCapacity:0];
    [params setObject:@(self.tableView.pageNum) forKey:@"currentPageNo"];
    [params setObject:@(self.tableView.pageCount) forKey:@"pageSize"];
    if (self.materialId) {
        [params setObject:self.materialId forKey:@"materialId"];
    }
    
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
      
    [networking GET:url parameters:params success:^(id  _Nonnull responseObject) {
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary *dic = responseObject[@"data"];
            NSArray *list = dic[@"goodsList"];
            if (list.count) {
                if (isHeader) {
                    [self.dataSource removeAllObjects];
                }
                for (NSDictionary *dictionary in list) {
                    QGMallBaseGoodsModel *model = [QGMallBaseGoodsModel yy_modelWithDictionary:dictionary];
                    if (model) {
                        [self.dataSource addObject:model];
                    }
                }
            }
            if (list.count == self.tableView.pageCount) {
                 [self.tableView endRefreshWithBusinessSuccess:YES hasNext:YES];
            }else{
                 [self.tableView endRefreshWithBusinessSuccess:YES hasNext:NO];
            }
            [self.tableView reloadData];
           
        }else{
            [self.tableView endRefreshWithBusinessSuccess:NO hasNext:YES];
            [self networkErrorPageWithPageNum:self.tableView.pageNum responseObject:responseObject error:nil];
        }
          
      } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
          [self networkErrorPageWithPageNum:self.tableView.pageNum responseObject:nil error:nil];
      }];
    
}



/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
