//
//  QGPasteAlertView.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/6.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGPasteAlertView.h"
#import "QGBasicUITool.h"
#import "QGAppCoreModelClickEvent.h"
#import "QGAnalyticsService.h"

@interface QGPasteAlertView ()

/// 复制的信息
@property (nonatomic, strong) NSString * pasteStr;
@end

@implementation QGPasteAlertView


/// 初始化方法
/// @param pasteStr 粘贴板文字
- (instancetype)initWithPasteStr:(NSString *)pasteStr
{
    if (self = [super init]) {
        self.popType = PopViewTypeAlert;
        self.contentView.backgroundColor = [UIColor clearColor];
        
        self.pasteStr = pasteStr;
        
        //底部背景
        UIView * contentView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor whiteColor]];
        contentView.layer.cornerRadius = 6;
        contentView.clipsToBounds = YES;
        [contentView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.left.right.bottom.inset(0);
        }];
        
        //图片
        UIImageView * topImgView = [UIImageView creatImageViewWithSuperView:contentView imageName:@"mall_auto_search"];
        [topImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.left.right.inset(0);
            make.height.mas_equalTo(topImgView.mas_width).multipliedBy(100/299.0);
        }];
        
        //文字展示区域
        UIView * pasteBGView = [UIView creatViewWithSuperView:contentView backgroundColor:[UIColor moduleSeparatorColorF7F7]];
        [pasteBGView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.mas_equalTo(topImgView.mas_bottom).offset(15);
            make.left.right.inset(15);
            make.height.mas_equalTo(94);
        }];
        
        //展示文案的label
        UILabel * pasteLabel = [UILabel creatLabelWithSuperView:pasteBGView title:pasteStr titleFontSize:[UIFont qg_regularFontOfSize:14] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        pasteLabel.numberOfLines = 0;
        [pasteLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.inset(6);
            make.bottom.mas_lessThanOrEqualTo(-6);
        }];
        
        //线条
        UIView * lineView = [UIView creatViewWithSuperView:contentView backgroundColor:[UIColor lineSeparatorColorDCDC]];
        [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(0);
            make.height.mas_equalTo(0.5);
            make.top.mas_equalTo(pasteBGView.mas_bottom).offset(20);
        }];
        
        //中间的分割线
        UIView * centerLine = [UIView creatViewWithSuperView:contentView backgroundColor:[UIColor lineSeparatorColorDCDC]];
        [centerLine mas_makeConstraints:^(MASConstraintMaker *make) {
           make.top.mas_equalTo(lineView.mas_bottom).offset(0);
           make.width.mas_equalTo(@(0.5));
           make.centerX.mas_equalTo(contentView);
           make.height.mas_equalTo(@(56));
           make.bottom.equalTo(contentView);
        }];
        
        
        //取消按钮
        UIButton * cancleButton = [UIButton creatButtonWithSuperView:contentView title:@"取消" titleFont:[UIFont qg_lightFontOfSize:18] textColor:[UIColor textColor3333]];
        [cancleButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.mas_equalTo(lineView.mas_bottom);
            make.left.bottom.inset(0);
            make.right.mas_equalTo(centerLine.mas_left);
        }];
        [cancleButton addTarget:self action:@selector(cancelButtonClick) forControlEvents:UIControlEventTouchUpInside];
        
        //搜索按钮
        UIButton * searchButton = [UIButton creatButtonWithSuperView:contentView title:@"搜索" titleFont:[UIFont qg_regularFontOfSize:18] textColor:[UIColor yyMainThemeColor]];
        [searchButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.mas_equalTo(lineView.mas_bottom);
            make.left.mas_equalTo(centerLine.mas_right);
            make.bottom.right.inset(0);
        }];
        [searchButton addTarget:self action:@selector(searchButtonClick) forControlEvents:UIControlEventTouchUpInside];
        
        
        
    }
    return self;
}

- (void)cancelButtonClick
{
    [self dismissView:nil];
}

- (void)searchButtonClick
{
    //神策埋点
    QGAppCoreModelClickEvent * clickEvent = [QGAppCoreModelClickEvent acmcEventWithPage:@"智能搜索" path:@"智能搜索" name:@"搜索" detail_name:nil acmc_model_other:self.pasteStr];
    [QGAnalyticsService analyticsTrackWithEvent:clickEvent];
        
    if (self.searchBlock) {
        self.searchBlock();
    }
    [self dismissView:nil];
}


- (void)showInView:(UIView *)superView
{
    [super showInView:superView];
    //结束编辑事件
    UIWindow *window = superView.window ? superView.window:[self getKeyWindow];
    [window endEditing:YES];
}
@end
