//
//  QGMallHorizontalGoodsCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/9.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallHorizontalGoodsCell.h"
#import "QGBasicUITool.h"
#import "QGDashPatternView.h"
#import "UIImageView+QGWebCache.h"
#import "NSString+CreditWallet.h"

@interface QGMallHorizontalGoodsCell ()

/// 商品图片
@property (nonatomic, strong) UIImageView * goodsImgView;

/// 渠道图标
@property (nonatomic, strong) UIImageView * channelImgView;

/// 优惠券背景视图
@property (nonatomic, strong) UIView * couponBGView;

/// 优惠金额
@property (nonatomic, strong) UILabel * couponAmountLabel;

/// 预估返现功能
@property (nonatomic, strong) UILabel * expectEarnAmountLabel;

/// 商品名称
@property (nonatomic, strong) UILabel * goodsNameLabel;

/// 商品原始价格
@property (nonatomic, strong) UILabel * goodsPriceLabel;

/// 商品售卖价格
@property (nonatomic, strong) UILabel * goodsSalePriceLabel;

/// 店铺名称
@property (nonatomic, strong) UILabel * shopNameLabel;

/// 销售数量
@property (nonatomic, strong) UILabel * saleCountLabel;

@end

@implementation QGMallHorizontalGoodsCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        self.contentView.backgroundColor = [UIColor moduleSeparatorColorF7F7];
        //白色背景
        UIView * whiteView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor whiteColor]];
        whiteView.layer.cornerRadius = 6;
        whiteView.clipsToBounds = YES;
        [whiteView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(15);
            make.top.inset(10);
            make.bottom.inset(0);
        }];
        
        //商品图片 宽高比1：1
        self.goodsImgView = [UIImageView creatImageViewWithSuperView:whiteView imageName:nil];
        self.goodsImgView.layer.cornerRadius = 6;
        self.goodsImgView.clipsToBounds = YES;
        [self.goodsImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.top.bottom.inset(0);
            make.width.mas_equalTo(self.goodsImgView.mas_height);
        }];
        
        //渠道图片
        self.channelImgView = [UIImageView creatImageViewWithSuperView:whiteView imageName:nil];
        [self.channelImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.goodsImgView.mas_right).offset(5);
            make.top.inset(6);
            make.size.mas_equalTo(CGSizeMake(24, 12));
        }];
        
        //商品名称
        self.goodsNameLabel = [UILabel creatLabelWithSuperView:whiteView title:nil titleFontSize:[UIFont qg_regularFontOfSize:13] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        self.goodsNameLabel.numberOfLines = 2;
        [self.goodsNameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.channelImgView);
            make.top.inset(4);
            make.right.inset(5);
        }];
        
        //商铺名称
        self.shopNameLabel = [UILabel creatLabelWithSuperView:whiteView title:nil titleFontSize:[UIFont qg_regularFontOfSize:10] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        [self.shopNameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
           make.left.mas_equalTo(self.channelImgView);
           make.right.inset(10);
           make.top.mas_equalTo(self.goodsNameLabel.mas_bottom).offset(2);
        }];
        
        
        //到手价
        self.goodsSalePriceLabel = [UILabel creatLabelWithSuperView:whiteView title:nil titleFontSize:[UIFont qg_mediumFontOfSize:16] textColor:[UIColor yyMainThemeColor] alignment:NSTextAlignmentLeft];
        [self.goodsSalePriceLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.channelImgView);
            make.bottom.inset(5);
            make.height.mas_equalTo(22);
        }];
        
        //原价
        self.goodsPriceLabel = [UILabel creatLabelWithSuperView:whiteView title:nil titleFontSize:[UIFont qg_regularFontOfSize:10] textColor:[UIColor textColor9999] alignment:NSTextAlignmentCenter];
        [self.goodsPriceLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.goodsSalePriceLabel.mas_right).offset(5);
            make.centerY.mas_equalTo(self.goodsSalePriceLabel);
        }];
        
        //划线
        UIView * priceLineView = [UIView creatViewWithSuperView:self.goodsPriceLabel backgroundColor:self.goodsPriceLabel.textColor];
        [priceLineView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.height.mas_equalTo(1);
            make.left.right.inset(-2);
            make.centerY.offset(0);
        }];
        
        //销售数量
        self.saleCountLabel = [UILabel creatLabelWithSuperView:whiteView title:nil titleFontSize:[UIFont qg_regularFontOfSize:10] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        [self.saleCountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.channelImgView);
            make.right.inset(10);
            make.height.mas_equalTo(14);
            make.bottom.mas_equalTo(self.goodsPriceLabel.mas_top).offset(-2);
        }];
        
        //优惠券
        self.couponBGView = [UIView creatViewWithSuperView:whiteView backgroundColor:[UIColor yyMainThemeColor]];
        self.couponBGView.layer.cornerRadius = 3;
        self.couponBGView.clipsToBounds = YES;
        [self.couponBGView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.channelImgView);
            make.height.mas_equalTo(16);
            make.bottom.mas_equalTo(self.saleCountLabel.mas_top).offset(-2);
        }];
        
        //券 文案
        UILabel * couponTitleLabel = [UILabel creatLabelWithSuperView:self.couponBGView title:@"券" titleFontSize:[UIFont qg_lightFontOfSize:11] textColor:[UIColor whiteColor] alignment:NSTextAlignmentCenter];
        [couponTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.top.bottom.inset(0);
            make.width.mas_equalTo(17.5);
        }];
        
        //分割线
        QGDashPatternView * lineView = [[QGDashPatternView alloc] initWithDashPatternType:QGDashPatternViewTypeLeft lineColor:[UIColor whiteColor] lineWidth:1 lineDashPattern:@[@"1.5",@"0.8"]];
        [self.couponBGView addSubview:lineView];
        [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(couponTitleLabel.mas_right);
            make.top.bottom.inset(3);
            make.width.mas_equalTo(1);
        }];
        
        //优惠金额
        self.couponAmountLabel = [UILabel creatLabelWithSuperView:self.couponBGView title:nil titleFontSize:[UIFont qg_lightFontOfSize:11] textColor:[UIColor whiteColor] alignment:NSTextAlignmentCenter];
        [self.couponAmountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(lineView.mas_right).offset(3);
            make.right.inset(3);
            make.centerY.offset(0);
        }];
        
        //预估返现
        self.expectEarnAmountLabel = [UILabel creatLabelWithSuperView:whiteView title:nil titleFontSize:[UIFont qg_regularFontOfSize:11] textColor:[UIColor whiteColor] alignment:NSTextAlignmentCenter];
        self.expectEarnAmountLabel.backgroundColor = [UIColor colorWithHexString:@"E9B176"];
        self.expectEarnAmountLabel.layer.cornerRadius = 3;
        self.expectEarnAmountLabel.clipsToBounds = YES;
        [self.expectEarnAmountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerY.height.mas_equalTo(self.couponBGView);
            make.right.mas_lessThanOrEqualTo(-10);
            make.left.mas_equalTo(self.couponBGView).offset(0);
        }];
        
        
        
    }
    return self;
}


- (void)setGoodsModel:(QGMallBaseGoodsModel *)goodsModel
{
    if (_goodsModel != goodsModel) {
        _goodsModel = goodsModel;
        [self.channelImgView setMallImageByNomalPlaceholderWithURLString:goodsModel.channelImg];
        [self.goodsImgView setMallImageByNomalPlaceholderWithURLString:goodsModel.goodsImg];
        self.goodsNameLabel.attributedText = goodsModel.showGoodsNameStr;
        //设置此处后，超出区域展示....
        self.goodsNameLabel.lineBreakMode = NSLineBreakByTruncatingTail;
        self.shopNameLabel.attributedText = goodsModel.showShopNameStr;
        self.couponAmountLabel.text = [NSString stringWithFormat:@"%@元",goodsModel.couponAmount];
        self.goodsSalePriceLabel.attributedText = goodsModel.showSalePriceStr;
        self.goodsPriceLabel.text = [NSString stringWithFormat:@"¥%@",goodsModel.goodsPrice];
        self.saleCountLabel.text = [NSString stringWithFormat:@"已售%@件",goodsModel.saleCount];
        self.expectEarnAmountLabel.text = [NSString stringWithFormat:@"预估返%@元   ",goodsModel.expectEarnAmount];
        
        //显示和隐藏逻辑
        self.couponBGView.hidden = [NSString isEmpty:goodsModel.couponAmount];
        self.saleCountLabel.hidden = [NSString isEmpty:goodsModel.saleCount];
        self.goodsPriceLabel.hidden = [NSString isEmpty:goodsModel.goodsPrice];
        self.expectEarnAmountLabel.hidden = [NSString isEmpty:goodsModel.expectEarnAmount];
        
        //没有优惠券，以最左边图片进行约束
        if ([NSString isEmpty:goodsModel.couponAmount]) {
            [self.expectEarnAmountLabel mas_updateConstraints:^(MASConstraintMaker *make) {
                 make.left.mas_equalTo(self.couponBGView).offset(0);
            }];
        }
        else
        {
            [self.expectEarnAmountLabel mas_updateConstraints:^(MASConstraintMaker *make) {
                 make.left.mas_equalTo(self.couponBGView).offset(goodsModel.expectEarnLeftOffset);
            }];
        }
    }
}

@end
