//
//  QGBaiChuanManager.m
//  VirtualPayment
//
//  Created by silicn on 2020/2/24.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGBaiChuanManager.h"
#import <AlibcTradeSDK/AlibcTradeSDK.h>

#import <AlibabaAuthSDK/albbsdk.h>
#import <AlibabaAuthSDK/ALBBUser.h>
#import "QGTalosNetwork.h"
#import "QGAppMacro.h"
#import "QGMallRequestApi.h"

#import "QGAuthAlertView.h"
#import "QGBaiChuanWebViewController.h"

#import "QGAlertView.h"

#import "QGUserInfo.h"
#import "QGGlobalConst.h"
#import "QGHUDManager.h"

/// 淘宝联盟授权成功
NSString *const AlimamaAuthSuccessNotification = @"AlimamaAuthSuccessNotification";

@interface QGBaiChuanManager ()
/// 是否成功注册
@property (nonatomic, assign)BOOL successRegister;
/// 淘宝联盟授权链接
@property (nonatomic, copy) NSString *taobaoAuthUrl ;


@end

@implementation QGBaiChuanManager

+ (instancetype)shareInstance
{
    static QGBaiChuanManager *manager = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        manager = [[self alloc]init];
    });
    return manager;
}

- (id)init
{
    self = [super init];
    if (self) {
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(baiChaunLogout) name:ModelCenterUserLogOutNotification object:nil];
    }
    return self;
}

/// 解除百川整个授权
- (void)baiChaunLogout
{
    [self unAuthLogin];
}

- (void)registerBaiChuanSDK
{
#if DEBUG
    [[AlibcTradeSDK sharedInstance] setDebugLogOpen:YES];
#else
    [[AlibcTradeSDK  sharedInstance] setDebugLogOpen:NO];
#endif
    [[AlibcTradeSDK sharedInstance] setEnv:AlibcEnvironmentRelease];
    [[AlibcTradeSDK sharedInstance] setIsvVersion:XcodeAppVersion];
    [[AlibcTradeSDK sharedInstance] setIsvAppName:@"真享花"];
    [[AlibcTradeSDK sharedInstance] setISVCode:@"com.baitiao.www"];

    [[AlibcTradeSDK sharedInstance] asyncInitWithSuccess:^{
        NSLog(@"[App]百川SDK初始化成功");
        /// 注册成功标志
        self.successRegister = YES;
    } failure:^(NSError *error) {
        NSLog(@"[App]百川SDK初始化Failure");
    }];
}


/// 获取淘宝授权链接
/// @param complete 回调结果
- (void)requestTaoBaoAuthUrlComplete:(void(^)(NSString *taobaoAuthUrl))complete
{
    [QGHUDManager showHud:nil];
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
    [networking GET:[QGMallRequestApi urlWithIndex:QGMallRequestServerMethodBaseConfig] parameters:nil success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary *data = responseObject[@"data"];
            if (data) {
                NSDictionary *config = data[@"taobaoConfig"];
                NSString *taobaoAuthUrl = config[@"taobaoAuthUrl"];
                if (taobaoAuthUrl) {
                    self.taobaoAuthUrl = taobaoAuthUrl;
                    if (complete) {
                        complete(taobaoAuthUrl);
                    }
                }
            }
        }else{
            [QGHUDManager showHud:@"获取数据异常"];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:@"网络错误,请稍后再试"];
    }];
}

#pragma mark - 授权逻辑以及检测

/// 联盟是否授权
+ (BOOL)isAliMamaAuthed
{
    return QGUserInfo.sharedUserInfo.alimamaAuth;
}

/// 内部判断授权,主要用作联盟授权的前置授权,没有其他作用
+ (BOOL)isTaoBaoAuthed
{
    return [[ALBBSession sharedInstance] isLogin];
}

/// 淘宝授权登录->百川
/// @param controller 当前的controller
- (void)authTaoBaoWithController:(nonnull UIViewController *)controller
                    successBlock:( void(^)(void) )authSuccessBlock
                    failureBlock:( void(^)(void) )authFailureBlock
{
        @weakify(self);
      if (![[ALBBSession sharedInstance] isLogin]) { /// 用户未登录
        dispatch_async(dispatch_get_main_queue(), ^{
            /// 弹窗提醒授权
            QGAuthAlertView *alert = [[QGAuthAlertView alloc]initWithType:QGAuthAlertViewTypeTaoBao];
            [alert showInView:controller.view];
            /// 同意授权
            alert.authBlock = ^{
                @strongify(self);
                [[ALBBSDK sharedInstance] setAuthOption: NormalAuth];
                [[ALBBSDK sharedInstance] auth:controller successCallback:^(ALBBSession *session) {
                    ALBBUser *user = session.getUser;
                    if (user) {
                        if (authSuccessBlock) authSuccessBlock();
                    }else{
                        [self unAuthLogin];
                        /// 特殊原因的失败,比如手机时间设置不正确,弹窗提醒
                        QGAlertView *alert = [[QGAlertView alloc]initWithTitle:@"提示" message:@"授权失败,请联系客服" cancelButtonTitle:@"知道了" sureButtonTitle:nil clickBlock:NULL];
                        [alert showInView:nil];
                        
                        if (authFailureBlock) authFailureBlock();
                    }
                }  failureCallback:^(ALBBSession *session, NSError *error) {
                    if (authFailureBlock) authFailureBlock();
                    [QGHUDManager showHud:@"授权失败"];
                }];
            };
        });
        }else{ /// 异常情况,SDK已经授权状态
            ALBBUser *user = [ALBBSession sharedInstance].getUser;
            if (user) {
               if (authSuccessBlock) authSuccessBlock();
            }else{
               if (authFailureBlock) authFailureBlock();
                [self unAuthLogin]; /// 否则解除登录状态
            }
      }
}

/// 淘宝联盟授权,无自定义弹窗确认
/// 如果淘宝没授权,默认自动淘宝授权
/// 授权结果只能检测本地QGUserInfo.sharedUserInfo.alimamaAuth 是否是YES
- (void)authAliMamaWithController:(nonnull UINavigationController *)navigationController
{
    if (!QGUserInfo.isLogin) return;
    /// H5淘宝自动授权
    if (self.taobaoAuthUrl == nil) {
        [self requestTaoBaoAuthUrlComplete:^(NSString *taobaoAuthUrl) {
            NSString *url = [taobaoAuthUrl stringByReplacingOccurrencesOfString:@"{uuid}" withString:QGUserInfo.sharedUserInfo.uuid];
            [self priviteOpenURL:url pid:nil controller:navigationController];
        }];
    }else{
        NSString *url = [self.taobaoAuthUrl stringByReplacingOccurrencesOfString:@"{uuid}" withString:QGUserInfo.sharedUserInfo.uuid];
        [self priviteOpenURL:url pid:nil controller:navigationController];
    }
}

/// 同时授权两个(淘宝+联盟),有自定义弹窗确认
/// @param navigationController 当前的navigationController
- (void)authAllAuthoritiesWithController:(nonnull UINavigationController *)navigationController
{
    [self authTaoBaoWithController:navigationController successBlock:^{
        /// 如果taobaoAuthUrl是空的,请求获取
        if (self.taobaoAuthUrl == nil) {
            [self requestTaoBaoAuthUrlComplete:^(NSString *taobaoAuthUrl) {
                NSString *url = [taobaoAuthUrl stringByReplacingOccurrencesOfString:@"{uuid}" withString:QGUserInfo.sharedUserInfo.uuid];
                [self priviteOpenURL:url pid:nil controller:navigationController];
            }];
        }else{
            NSString *url = [self.taobaoAuthUrl stringByReplacingOccurrencesOfString:@"{uuid}" withString:QGUserInfo.sharedUserInfo.uuid];
            [self priviteOpenURL:url pid:nil controller:navigationController];
        }
    } failureBlock:NULL];
}


/// 解除当前的授权状态
- (void)unAuthLogin
{
    /// 增加判断会导致一些授权异常状态无法解除授权,比如手机时间设置错误,导致授权成功后授权状态错误.
//    if ([ALBBSession sharedInstance].isLogin) {
        [[ALBBSDK sharedInstance] logout];
//    }
    QGUserInfo *userInfo = [QGUserInfo sharedUserInfo];
    if (userInfo.alimamaAuth) {
        userInfo.alimamaAuth = NO;
    }
}

#pragma mark - 打开淘宝,跳转逻辑

- (void)openURL:(nonnull NSString *)url
       taokePid:(nullable NSString *)pid
navigationController:(nonnull UINavigationController *)navigationController;
{
    /// 如果没授权登录,拉起授权登录
    /// 淘宝授权给百川,百川授权给淘宝联盟
    if (QGUserInfo.sharedUserInfo.alimamaAuth) {
         [self priviteOpenURL:url pid:pid controller:navigationController];
    }else{
        [self authTaoBaoWithController:navigationController successBlock:^{
           /// 如果taobaoAuthUrl是空的,请求获取
            if (self.taobaoAuthUrl == nil || [self.taobaoAuthUrl isEqualToString:@""]) {
                [self requestTaoBaoAuthUrlComplete:^(NSString *taobaoAuthUrl) {
                    NSString *url = [taobaoAuthUrl stringByReplacingOccurrencesOfString:@"{uuid}" withString:QGUserInfo.sharedUserInfo.uuid];
                    [self priviteOpenURL:url pid:nil controller:navigationController];
                }];
            }else{
                NSString *url = [self.taobaoAuthUrl stringByReplacingOccurrencesOfString:@"{uuid}" withString:QGUserInfo.sharedUserInfo.uuid];
                [self priviteOpenURL:url pid:nil controller:navigationController];
            }
        } failureBlock:NULL];
    }
}


/// 跳转淘宝
/// @param url 商品链接
/// @param pid 淘宝联盟推广位
/// @param navigationController 自定义Push的navigationController
- (void)priviteOpenURL:(NSString *)url pid:(NSString *)pid controller:(UINavigationController *)navigationController
{
     AlibcTradeShowParams *showParam = [[AlibcTradeShowParams alloc]init];
    showParam.openType = AlibcOpenTypeAuto;
    showParam.isNeedCustomNativeFailMode = YES;
    showParam.nativeFailMode = AlibcNativeFailModeJumpH5;
    // 手淘打不开URL,降级跳转页面
    showParam.degradeUrl = @"https://mos.m.taobao.com/activity_newer?from=pub&pid=mm_876970101_1285600225_110028350341&union_lens=lensId%3APUB%401583139388%400b0af2cb_0e20_1709a75fa66_086c%4001";
    
    AlibcTradeTaokeParams *taokeParam = nil;
    if (pid) {
        taokeParam = [[AlibcTradeTaokeParams alloc]init];
        taokeParam.pid = pid;
        taokeParam.extParams = @{@"taokeAppkey":@"28360650"};
    }
    
    dispatch_async(dispatch_get_main_queue(), ^{
        
        QGBaiChuanWebViewController *webController = [[QGBaiChuanWebViewController alloc]init];
        NSInteger res = [[AlibcTradeSDK sharedInstance].tradeService openByUrl:url identity:@"trade" webView:webController.myWebView parentController:webController showParams:showParam taoKeParams:taokeParam  trackParam:nil tradeProcessSuccessCallback:^(AlibcTradeResult * _Nullable result) {
            if (result.result == AlibcTradeResultTypePaySuccess) {
                 NSLog(@"交易结果Success = %@",result);
            }
        } tradeProcessFailedCallback:^(NSError * _Nullable error) {
            //        退出交易流程
            if (error.code==AlibcErrorCancelled) {
                return ;
            }
            NSDictionary *infor=[error userInfo];
            NSArray*  orderid=[infor objectForKey:@"orderIdList"];
            NSString *tip=[NSString stringWithFormat:@"交易失败:\n订单号\n%@",orderid];
            NSLog(@"交易结果Failure = %@",tip);
        }];
        
        /// 如果拉起手淘失败,页面内打开
        if (res != 0) {
           /// 如果传的是navigationController,则自定义push,否则不处理
           if ([navigationController isKindOfClass:[UINavigationController class]]) {
               [navigationController pushViewController:webController animated:YES];
           }
        }
        [QGHUDManager hideHud];
    });
}

- (void)pushCustomController:(UIViewController *)webController navigationController:(UINavigationController *)navigationController
{
   
}

/// 已经弃用
/// 绑定用户信息,上报成功才算是绑定成功,已经弃用
/// @param user 用户
- (void)upLoadUserInfo:(ALBBUser *)user
{
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
    NSMutableDictionary *param = [NSMutableDictionary dictionary];
    [param setObject:user.nick ? user.nick :@"" forKey:@"nickName"];
    [param setObject:user.avatarUrl ? user.avatarUrl :@"" forKey:@"avatarUrl"];
    if (user.openId) {
         [param setObject:user.openId forKey:@"openId"];
    }
    [param setObject:user.openSid ? user.openSid :@"" forKey:@"openSid"];
    if (user.topAuthCode) {
        [param setObject:user.topAuthCode forKey:@"authCode"];
    }
    if (user.topAccessToken) {
        [param setObject:user.topAccessToken forKey:@"accessToken"];
    }
    [QGHUDManager showHud:nil];
    [networking POST:[QGMallRequestApi urlWithIndex:QGMallRequestServerMethodBindAuthUser] parameters:param success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSLog(@"[App]-------淘宝授权信息已经上报成功");
        }else{
            NSLog(@"[App]-------淘宝授权信息上报失败 %@",responseObject[@"msg"]);
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager hideHud];
        [self unAuthLogin];
        QGAlertView *alert = [[QGAlertView alloc]initWithTitle:@"提示" message:@"网络错误,授权失败" cancelButtonTitle:@"知道了" sureButtonTitle:nil clickBlock:NULL];
        [alert showInView:nil];
        /// 上报失败不做处理
    }];
}



/// 错误类型处理
- (void)handleRes:(NSInteger)res
{
    if (res == 0) return;  /// 手淘打开
    if (res == -1) {
        [QGHUDManager showHud:@"入参错误,请稍后再试"];
    }else if (res == -2){
        [QGHUDManager showHud:@"打开方式错误,请联系客服"];
    }else if (res == -3){
        [QGHUDManager showHud:@"打开页面失败"];
    }else if (res == -4){
        [QGHUDManager showHud:@"初始化失败,请联系客服"];
    }else if (res == -5){
        [QGHUDManager showHud:@"当前版本过低"];
    }else if (res == -6){
        [QGHUDManager showHud:@"打开手淘被拒绝"];
    }else{
        [QGHUDManager showHud:@"未知错误,请稍后再试"];
    }
}


#pragma mark - Application Handle

- (BOOL)application:(UIApplication *)application openURL:(NSURL *)url options:(NSDictionary<NSString *, id> *)options
{
    return [[AlibcTradeSDK sharedInstance] application:application
                                               openURL:url
                                               options:options];
}

- (BOOL)application:(UIApplication *)application openURL:(NSURL *)url sourceApplication:(NSString *)sourceApplication annotation:(id)annotation
{
   return [[AlibcTradeSDK sharedInstance] application:application
                                        openURL:url
                              sourceApplication:sourceApplication
                                     annotation:annotation];
}


- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

@end
