//
//  QGBaiChuanManager.h
//  VirtualPayment
//
//  Created by silicn on 2020/2/24.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

/// 淘宝联盟授权成功
extern NSString *const AlimamaAuthSuccessNotification;

@interface QGBaiChuanManager : NSObject

+ (instancetype)shareInstance;


/// 注册百川SDK
- (void)registerBaiChuanSDK;


/// 打开淘宝,并跳转指定的商品位置 (检测授权并且打开淘宝链接，未授权情况下会提示用户授权)
/// Notice:不需要淘宝授权也能跳转指定的商品,默认会先授权
/// @param url 商品链接
/// @param pid 商品的推广位-淘宝联盟
/// @param navigationController 当前的navigationController
- (void)openURL:(nonnull NSString *)url
       taokePid:(nullable NSString *)pid
navigationController:(nonnull UINavigationController *)navigationController;


#pragma mark - 授权状态
///----------------------------以下方法可以不使用

/// 联盟是否授权
+ (BOOL)isAliMamaAuthed;


/// 仅淘宝授权登录
/// @param controller 当前的navigationController
- (void)authTaoBaoWithController:(nonnull UIViewController *)controller
                    successBlock:(void(^)(void))authSuccessBlock
                    failureBlock:(nullable void(^)(void))authFailureBlock;

/// 淘宝联盟授权,但是没有自定义弹窗确认
/// 如果淘宝没授权,默认自动淘宝授权
/// 授权结果只能检测本地QGUserInfo.sharedUserInfo.alimamaAuth 是否是YES
- (void)authAliMamaWithController:(nonnull UINavigationController *)navigationController;


/// 同时授权两个(淘宝+联盟),有自定义弹窗确认
/// @param navigationController 当前的navigationController
- (void)authAllAuthoritiesWithController:(nonnull UINavigationController *)navigationController;


#pragma mark - 解除授权

/// 登出淘宝授权,一般外边调用
/// 当前调用时机:
/// 1, 用户退出登录,自动调用这个方法
/// 2, 用户淘宝授权isLogin = YES,但是AlimamaAuth=No.即做了淘宝授权,但是没做联盟授权
- (void)unAuthLogin;

/// 判断淘宝是否授权
+ (BOOL)isTaoBaoAuthed;


#pragma mark - AppDelegate URL 处理回调

- (BOOL)application:(UIApplication *)app openURL:(NSURL *)url options:(NSDictionary<NSString *, id> *)options;

- (BOOL)application:(UIApplication *)application openURL:(NSURL *)url sourceApplication:(NSString *)sourceApplication annotation:(id)annotation;

@end

NS_ASSUME_NONNULL_END
