//
//  QGBaseGoodsModel.m
//  VirtualPayment
//
//  Created by 张博 on 2020/2/26.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallBaseGoodsModel.h"
#import "ZHAttributedLabelTool.h"
#import "QGBasicUITool.h"
@implementation QGMallBaseGoodsModel


+ (NSArray *)modelPropertyBlacklist {
    return @[@"showSalePriceStr", @"showGoodsNameStr", @"showShopNameStr",@"horizontalCellHeight",@"verticalCellHeight",@"expectEarnLeftOffset"];
}


- (NSAttributedString *)showGoodsNameStr
{
    if (_showGoodsNameStr.length == 0 && self.goodsName.length > 0) {
        
        ZHAttributedLabelTool * nameTool = [[ZHAttributedLabelTool alloc] initWithText:self.goodsName font:[UIFont qg_regularFontOfSize:13] color:[UIColor textColor3333]];
        //图片宽度24 + 3的距离
        [nameTool setFirstLineHeadIndent:24 + 3];
        _showGoodsNameStr = [nameTool getResultString];
    }
    return _showGoodsNameStr;
}


- (NSAttributedString *)showSalePriceStr
{
    if (_showSalePriceStr.length == 0 && self.goodsSalePrice.length > 0) {
        NSString * salePriceBegan = @"¥";
        NSString * salePriceEnd = self.goodsSalePrice;
        //拼接之后的所有价格
        NSString * allPriceStr = [NSString stringWithFormat:@"%@%@",salePriceBegan,salePriceEnd];
        
        //开始初始化富文本
        ZHAttributedLabelTool * priceTool = [[ZHAttributedLabelTool alloc] initWithText:allPriceStr font:[UIFont qg_mediumFontOfSize:16] color:[UIColor yyMainThemeColor]];
        [priceTool addFont:[UIFont qg_mediumFontOfSize:12] range:[allPriceStr rangeOfString:salePriceBegan]];
        _showSalePriceStr = priceTool.getResultString;
    }
    return _showSalePriceStr;
}


- (NSAttributedString *)showShopNameStr
{
    if (_showShopNameStr.length == 0 && self.shopName.length > 0) {
         ZHAttributedLabelTool * priceTool = [[ZHAttributedLabelTool alloc] initWithText:self.shopName font:[UIFont qg_regularFontOfSize:10] color:[UIColor textColor9999]];
        [priceTool addAttachmentWithImageName:@"mall_search_result_shop" index:0 size:CGRectMake(0, -3, 14, 14)];
        _showShopNameStr = priceTool.getResultString;
    }
    return _showShopNameStr;
}


- (CGFloat)horizontalCellHeight
{
    return 130;
}

- (CGSize)verticalCellSize
{
    if (CGSizeEqualToSize(_verticalCellSize, CGSizeZero)) {
        //先计算出图片的宽度
        CGFloat verticalCellWidth = (MAINSCREEN_WIDTH - 15 * 2 - 10)/2.0;
        //图片宽高比为1：1，所以用图片宽度加上剩余距离 + 10的间距
        CGFloat verticalCellHeight = verticalCellWidth + 133 + 10;
        _verticalCellSize = CGSizeMake(verticalCellWidth, verticalCellHeight);
    }
    return _verticalCellSize;
}


- (CGFloat)expectEarnLeftOffset
{
    if (_expectEarnLeftOffset == 0 && self.couponAmount.length > 0) {
        NSString * couponStr = [NSString stringWithFormat:@"%@元",self.couponAmount];
        CGFloat couponWidth = [NSString getWidthWithContent:couponStr height:16 UIFont:[UIFont qg_lightFontOfSize:11]];
        _expectEarnLeftOffset = 21 + couponWidth + 3 + 3;
    }
    return _expectEarnLeftOffset;
}


@end
