//
//  QGBaseGoodsModel.h
//  VirtualPayment
//
//  Created by 张博 on 2020/2/26.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGBaseModel.h"

NS_ASSUME_NONNULL_BEGIN

/// 基础的商品模型类，存放商品共用参数（主要为列表服务）
@interface QGMallBaseGoodsModel : QGBaseModel

///渠道，1淘宝， 2天猫，3京东，4饿了么，5苏宁
@property (nonatomic, copy) NSString * channel;

/// 渠道小图标
@property (nonatomic, copy) NSString * channelImg;

/// 优惠金额
@property (nonatomic, copy) NSString * couponAmount;

/// 优惠金额有效期
@property (nonatomic, copy) NSString * couponValidDate;

/// 商品ID
@property (nonatomic, copy) NSString * goodsId;

/// 商品图片
@property (nonatomic, copy) NSString * goodsImg;

/// 商品名称
@property (nonatomic, copy) NSString * goodsName;

/// 商品原始价格
@property (nonatomic, copy) NSString * goodsPrice;

/// 商品售买价格
@property (nonatomic, copy) NSString * goodsSalePrice;

/// 商品标签 例如：七天无理由退货
@property (nonatomic, copy) NSString * goodsTags;

/// 销售数量
@property (nonatomic, copy) NSString * saleCount;

/// 商铺id
@property (nonatomic, copy) NSString * shopId;

/// 商铺名称
@property (nonatomic, copy) NSString * shopName;

/// 商品属地
@property (nonatomic, copy) NSString * provcity;

/// 商品邮费
@property (nonatomic, copy) NSString * shipFee;

/// 预估返现
@property (nonatomic, copy) NSString * expectEarnAmount;


/****************为方便展示自定义属性******************/

/// 展示商品售卖价格
@property (nonatomic, strong) NSAttributedString * showSalePriceStr;

/// 展示商品名称
@property (nonatomic, strong) NSAttributedString * showGoodsNameStr;

/// 展示商铺名称
@property (nonatomic, strong) NSAttributedString * showShopNameStr;

/// 水平cell的高度
@property (nonatomic, assign) CGFloat horizontalCellHeight;

/// 竖直cell的size
@property (nonatomic, assign) CGSize verticalCellSize;

/// 预估返现左侧偏移量
@property (nonatomic, assign) CGFloat expectEarnLeftOffset;

@end

NS_ASSUME_NONNULL_END
