//
//  QGRootTabbarController.m
//  VirtualPayment
//
//  Created by 张博 on 2019/5/5.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGRootTabbarController.h"
#import "QGCustomTabBar.h"

//TabbarController
#import "QGCardViewController.h"
#import "QGNewUserCenterViewController.h"
#import "QGBaseNavigationController.h"
#import "QGQuotaManagerViewController.h"
#import "QGMallContainerViewController.h"
#import "QGCashbackViewController.h"

//View
#import "QGScreenshotsFeedbackView.h"

//Model
#import "QGAppTabClickEvent.h"

//Tool
#import "SystemManager.h"
#import "QGAppMacro.h"
@implementation QGRootTabbarController 

- (void)dealloc
{
    [self removeNotification];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    //添加通知
    [self addNotification];
    self.view.backgroundColor = [UIColor whiteColor];
    [self initNormalVC];
    [SystemManager shareInstance].tabbarController = self;
}


- (void)initNormalVC {
    
    NSMutableArray * barItems = [NSMutableArray arrayWithCapacity:0];

    
    //省钱模块
    QGTabBarItemModel * mallModel = [[QGTabBarItemModel alloc] initWithTitle:@"省钱" viewControllerName:NSStringFromClass([QGMallContainerViewController class]) nomalImage:[UIImage imageNamed:@"tabbar_mall_default"] selectImage:[UIImage imageNamed:@"tabbar_mall_highlight"]];
    [barItems addObject:mallModel];
    
    
    //赚钱
    QGTabBarItemModel * cashbackModel = [[QGTabBarItemModel alloc] initWithTitle:@"赚钱" viewControllerName:NSStringFromClass([QGCashbackViewController class]) nomalImage:[UIImage imageNamed:@"tabbar_payback_default"] selectImage:[UIImage imageNamed:@"tabbar_payback_highlight"]];
    [barItems addObject:cashbackModel];
    
    //享花卡
    QGTabBarItemModel * cardModel = [[QGTabBarItemModel alloc] initWithTitle:@"享花卡" viewControllerName:NSStringFromClass([QGCardViewController class]) nomalImage:[UIImage imageNamed:@"tabbar_card_default"] selectImage:[UIImage imageNamed:@"tabbar_card_highlight"]];
    [barItems addObject:cardModel];

    
    //我的
    QGTabBarItemModel * usercenterModel = [[QGTabBarItemModel alloc] initWithTitle:@"我的" viewControllerName:NSStringFromClass([QGNewUserCenterViewController class]) nomalImage:[UIImage imageNamed:@"tabbar_usercenter_default"] selectImage:[UIImage imageNamed:@"tabbar_usercenter_highlight"]];
    [barItems addObject:usercenterModel];
    
    [self initTabWithBarItems:barItems];
    
    //创建VC
    NSMutableArray * viewControllers = [NSMutableArray arrayWithCapacity:0];
    for (QGTabBarItemModel * barItemModel in barItems) {
        UIViewController * viewController = [self creatControllerWithName:barItemModel.viewControllerName];
        [viewControllers addObject:viewController];
    }
    self.viewControllers = viewControllers;
    //此处会影响viewControllers中tableView的高度
//    [[UITabBar appearance] setTranslucent:NO];
}

- (void)initTabWithBarItems:(NSArray *)barItems
{
    QGCustomTabBar * myTabbar = [[QGCustomTabBar alloc] initWithBarItems:barItems];
    myTabbar.delegate = self;
    myTabbar.titleHighlightColor = [UIColor yyMainThemeColor];
    //修复iOS13颜色问题
    myTabbar.tintColor = [UIColor yyMainThemeColor];
    [self setValue:myTabbar forKey:@"tabBar"];
}


- (UIViewController *)creatControllerWithName:(NSString *)className{
    if (className.length == 0) {
        return [UIViewController new];
    }
    Class class = NSClassFromString(className);
    UIViewController *controller = [[class alloc] init];
    QGBaseNavigationController *navController = [[QGBaseNavigationController alloc] initWithRootViewController:controller];
    return navController;
}


- (void)tabBar:(UITabBar *)tabBar didSelectItem:(UITabBarItem *)item
{
    NSInteger oldIndex = self.selectedIndex;
    NSInteger selectIndex = [tabBar.items indexOfObject:item];
    
    //赚钱页面 | 省钱
    if (selectIndex == 0 || selectIndex == 1) {
        QGAppTabClickEvent * event = [QGAppTabClickEvent tabClickEventWithTabName:nil nameLabel:item.title];
        [QGAnalyticsService analyticsTrackWithEvent:event];
    }

    //赚钱首页 并且未登录
    if (selectIndex == 1 && ![QGUserInfo sharedUserInfo].isLogin) {
        @weakify(self);
        [self showLoginViewControllerCompletion:nil cancleBlock:^{
            //如果没有登录，就跳回原来的地方
            @strongify(self);
            self.selectedIndex = oldIndex;
        }];
    }
    
    
}


/// 跳转省钱
- (void)jumpMall
{
    self.selectedIndex = 0;
}

/// 跳转赚钱
- (void)jumpCashback
{
    self.selectedIndex = 1;
}

/**
 跳转享花卡
 */
- (void)jumpCard
{
    self.selectedIndex = 2;
}

/**
 跳转个人中心
 */
- (void)jumpMy
{
    self.selectedIndex = 3;
}


#pragma mark - Notification
- (void)addNotification
{
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(userDidTakeScreenshot) name:UIApplicationUserDidTakeScreenshotNotification object:nil];
}

- (void)removeNotification
{
    [[NSNotificationCenter defaultCenter] removeObserver:self name:UIApplicationUserDidTakeScreenshotNotification object:nil];
}

//截屏响应
- (void)userDidTakeScreenshot
{
    UIImage * screenshotImage =  [self takeScreenshot];
    NSData * data = UIImageJPEGRepresentation(screenshotImage, 0.5);
    //反馈
    QGScreenshotsFeedbackView * feedbackView = [[QGScreenshotsFeedbackView alloc] init];
    [feedbackView showWithImage:[UIImage imageWithData:data]];
    
    @weakify(self);
    feedbackView.serviceButtonClickBlock = ^{
        @strongify(self);
        [self jumpService];
    };
    
}

- (void)jumpService
{
    @weakify(self);
    if (![QGUserInfo isLogin]) {
        [self showLoginViewControllerCompletion:^{
            @strongify(self);
            [self jumpService];
        }];
        return;
    }
    [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGBaseWebViewController) parameters:@{@"urlString":VCCServiceUrl} handlerBlock:nil];
}

#pragma mark - 截取当前屏幕
-(UIImage *)takeScreenshot {
    CGSize imageSize = CGSizeZero;
    CGSize screenSize = [UIScreen mainScreen].bounds.size;
    UIInterfaceOrientation orientation = [UIApplication sharedApplication].statusBarOrientation;

    if (UIInterfaceOrientationIsPortrait(orientation)) {
        imageSize = screenSize;
    } else {
        imageSize = CGSizeMake(screenSize.height, screenSize.width);
    }
    
    UIGraphicsBeginImageContextWithOptions(imageSize, false, 0);
    CGContextRef context = UIGraphicsGetCurrentContext();
    if (context) {
        for (UIWindow *window in [UIApplication sharedApplication].windows) {
            CGContextSaveGState(context);
            CGContextTranslateCTM(context, window.center.x, window.center.y);
            CGContextConcatCTM(context, window.transform);
            CGContextTranslateCTM(context, -window.bounds.size.width * window.layer.anchorPoint.x, -window.bounds.size.height * window.layer.anchorPoint.y);
            
            if (orientation == UIInterfaceOrientationLandscapeLeft) {
                CGContextRotateCTM(context, M_PI_4);
                CGContextTranslateCTM(context, 0, -imageSize.width);
            } else if (orientation == UIInterfaceOrientationLandscapeRight) {
                CGContextRotateCTM(context, - M_PI_2);
                CGContextTranslateCTM(context, -imageSize.height, 0);
            } else if (orientation == UIInterfaceOrientationPortraitUpsideDown) {
                CGContextRotateCTM(context, M_PI);
                CGContextTranslateCTM(context, -imageSize.width, -imageSize.height);
            }
            
            if ([window respondsToSelector:@selector(drawViewHierarchyInRect:afterScreenUpdates:)]) {
                [window drawViewHierarchyInRect:window.bounds afterScreenUpdates:YES];
            } else {
                [window.layer renderInContext:context];
            }
            
            CGContextRestoreGState(context);
        }
    }
    
    UIImage *image = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    
    return image;
}

@end
