//
//  QGLoginRequestApi.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/24.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGLoginRequestApi.h"

@implementation QGLoginRequestApi


+(NSString *)urlWithQGLoginRequestServerMethod:(QGLoginRequestServerMethod)method
{
    NSString *url;
    switch (method) {
        case QGLoginRequestServerMethodLogin://1密码登录
            url = @"vcc/usercenter/login_by_pwd";
            break;
        case QGLoginRequestServerMethodRegisterSendSms://2发送短信验证码
            url = @"vcc/usercenter/send_vcc_sms_code";
            break;
        case QGLoginRequestServerMethodLoginCheckSms://3登录校验验证码
            url = @"vcc/usercenter/fast_login_by_sms_code";
            break;
        case QGLoginRequestServerMethodResetPasswordCheckSms://4设置密码校验验证码
            url = @"vcc/usercenter/findPwd/verifySmsCode";
            break;
        case QGLoginRequestServerMethodSetNewPasswordCode://5设置新密码短信
            url = @"vcc/usercenter/findPwd/newPwd";
            break;
        case QGLoginRequestServerMethodAuthRefreshToken://7刷新Token
            url = @"vcc/usercenter/refreshToken/token";
            break;
        case QGLoginRequestServerMethodSmsCaptcha://8获取图形验证码
            url = @"vcc/usercenter/qg_captcha";
            break;
        case QGLoginRequestServerMethodSmsCaptchaType://9发送验证码的验证类型
            url = @"vcc/usercenter/captcha_type";
            break;
            //微信登录绑定校验
        case QGLoginRequestServerMethodCheckWechatBinding:
            url = @"vcc/external/login/weChat_opId";
            break;
            //微信登录关联手机号
        case QGLoginRequestServerMethodLoginWechat:
            url = @"vcc/external/login/weChat";
            break;
            //apple登录绑定校验
        case QGLoginRequestServerMethodCheckAppleBinding:
            url = @"vcc/external/login/apple_idtoken";
            break;
            //苹果登录绑定校验
        case QGLoginRequestServerMethodLoginApple:
            url = @"vcc/external/login/apple";
            break;
            //查询微信,Apple,百川是否授权状态
        case QGLoginRequestServerMethodQueryStatus:
            url = @"vcc/external/login/auth_status";
            break;
            // 查询当前unionId是否可用
        case QGLoginRequestServerMethodBindAvailable:
            url = @"vcc/external/login/auth_status/authId";
            break;
            ///解除微信授权
        case QGLoginRequestServerMethodUnBindWeChat:
            url = @"vcc/external/login/weChat/unbind";
            break;
            ///微信授权获取验证码
        case QGLoginRequestServerMethodWxVerifyGetCode:
            url = @"vcc/account/send_verify_code";
            break;
            
        default:
            break;
    }
    return url;
}

@end
