//
//  QGRetriecePasswordViewController.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/19.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGRetriecePasswordViewController.h"
#import "QGRetrievePasswordCell.h"
#import "QGLoginBottomBtnTableViewCell.h"
#import "QGCountDown.h"
#import "QGBasicUITool.h"
#import "QGSendMessageCodeManger.h"
#import "QGLoginRequestApi.h"

@interface QGRetriecePasswordViewController ()
///自定义tableView header
@property (nonatomic, strong)UIView *tableHeaderView;
///下一步按钮，方便修改状态
@property (nonatomic, strong)QGGradientShadowButton *loginButton;
///自定义定时器
@property (nonatomic, strong)QGCountDown *countDownTimer;
///倒计时剩余时间
@property (nonatomic, assign)NSInteger residueTime;
///接收回调输入的验证码
@property (nonatomic, copy)NSString *code;
///重新获取验证码
@property (nonatomic, strong)UIButton *getCodeBtn;
///获取短信验证码管理类
@property (nonatomic, strong)QGSendMessageCodeManger *sendVerifyCodeManger;

@property (nonatomic, copy)NSString *phoneNumberStr;

@end

@implementation QGRetriecePasswordViewController

- (void)viewDidLoad {
    [super viewDidLoad];

    self.title = @"找回登录密码";
    
    //创建header
    UILabel *titleLable = [UILabel creatLabelWithSuperView:self.tableHeaderView title:@"已发送短信验证码至该账号绑定的" titleFontSize:[UIFont qg_mediumFontOfSize:18] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
    UILabel *subTitleLable = [UILabel creatLabelWithSuperView:self.tableHeaderView title:[NSString stringWithFormat:@"手机号 %@",self.phoneNumberStr] titleFontSize:[UIFont qg_mediumFontOfSize:18] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
    [titleLable mas_makeConstraints:^(MASConstraintMaker *make) {
        make.topMargin.mas_equalTo(20);
        make.left.right.equalTo(self.tableHeaderView).inset(20);
        make.height.mas_equalTo(20);
    }];
    [subTitleLable mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(titleLable.mas_bottom).offset(10);
        make.left.right.equalTo(self.tableHeaderView).inset(20);
        make.height.mas_equalTo(20);
    }];
    self.tableView.tableHeaderView = self.tableHeaderView;
    
    //初始化定时器
    self.residueTime = 60;
    self.countDownTimer = [[QGCountDown alloc]init];
    
    //初始化发送验证码管理类
    self.sendVerifyCodeManger = [[QGSendMessageCodeManger alloc] init];
    
    __weak typeof(self) weakSelf = self;
    [self.sendVerifyCodeManger sendMessageCodeWithPhoneNumber:self.phoneNumberStr success:^{
        [weakSelf fireTimer];
    } fail:^{
        weakSelf.getCodeBtn.userInteractionEnabled = YES;
    }];
    
}

-(void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
}

//启动定时器
-(void)fireTimer
{
    [self.countDownTimer countDownWithPER_SECBlock:^{
        self.residueTime--;
        if (self.residueTime == 0) {
            [self.countDownTimer destoryTimer];
            self.residueTime = 60;
            [self.getCodeBtn setTitle:@"重新发送" forState:UIControlStateNormal];
            self.getCodeBtn.userInteractionEnabled = YES;
        }else{
            
            [self.getCodeBtn setTitle:[NSString stringWithFormat:@"重新发送(%lds)",(long)self.residueTime] forState:UIControlStateNormal];
            
            
        }
    }];
}


//验证码校验
-(void)checkVerifyCodeRequest
{
    [self.view endEditing:YES];
    [QGHUDManager showHud:nil];
    
    NSString *url = [QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodResetPasswordCheckSms];
    [[QGTalosNetwork shareManager] POST:url parameters:@{@"phoneNo":self.phoneNumberStr,@"verificationCode":self.code} success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        //业务处理成功
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            if (![NSString isEmpty:[responseObject valueForKeyPath:@"data.verifySmsCodeToken"]]) {//跳转到设置新密码页
                [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGSucceedRetrieceSetNewPasswordViewController] parameters:@{@"phoneNumberStr":self.phoneNumberStr, @"token":[responseObject valueForKeyPath:@"data.verifySmsCodeToken"]} handlerBlock:self.callBackBlock];
            }
        }
        //业务处理失败
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
    }];
}



-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 2;
}
-(CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row == 0) {
        return 81;
    }else{
        return 85;
    }
}
-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    __weak typeof(self)weakSelf = self;

    if (indexPath.row == 0) {
        
        QGRetrievePasswordCell *cell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([QGRetrievePasswordCell class])];
        if (!cell) {
            cell = [[QGRetrievePasswordCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:NSStringFromClass([QGRetrievePasswordCell class]) cellTitle:@"验证码" placeHolder:@"请输入短信验证码"];
        }

        cell.cellBlock = ^(NSString *code) {
            weakSelf.code = code;
            if (weakSelf.code.length == 0) {
                [weakSelf.loginButton setGradientButtonIsClickEnabled:NO];

            }else{
                [weakSelf.loginButton setGradientButtonIsClickEnabled:YES];

            }
        };
        
        cell.cellBtnCallBack = ^{//重新发送
            weakSelf.getCodeBtn.userInteractionEnabled = NO;
            [weakSelf fireTimer];
            [weakSelf.sendVerifyCodeManger sendMessageCodeWithPhoneNumber:self.phoneNumberStr success:nil fail:nil];
        };
        self.getCodeBtn = cell.getcodeBtn;
        return cell;
    }else{
        
        QGLoginBottomBtnTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([QGLoginBottomBtnTableViewCell class])];
        if (!cell) {
            cell = [[QGLoginBottomBtnTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:NSStringFromClass([QGLoginBottomBtnTableViewCell class]) btnTitle:@"下一步" padding:20];
        }
        self.loginButton = cell.loginButton;
        
        cell.cellBlock = ^(UIButton *nextBtn) {
            //下一步按钮点击
            [weakSelf checkVerifyCodeRequest];
        };
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        
        return cell;
    }
}

-(UIView *)tableHeaderView
{
    if (!_tableHeaderView) {
        _tableHeaderView = [[UIView alloc]init];
        _tableHeaderView.backgroundColor = [UIColor whiteColor];
        _tableHeaderView.bounds = CGRectMake(0, 0, MAINSCREEN_WIDTH, 90);
        
    }
    return _tableHeaderView;
}


-(BOOL)checkParameters:(NSDictionary *)param
{
    if ([[param objectForKey:@"phoneNumberStr"] isNumber]) {
        return YES;
    }
    
    return NO;
}

- (void)transferParameters:(NSDictionary *)param {
    
    self.phoneNumberStr = [param objectForKey:@"phoneNumberStr"];
}
@end
