//
//  QGRegisterViewController.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/18.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGRegisterViewController.h"

//Tool
#import "QGBasicUITool.h"
#import "QGSendMessageCodeManger.h"
#import "QGThirdPlatformService.h"
#import "QGLoginRequestApi.h"
#import "QGPushService.h"

//View
#import "QGPhoneInputWithTitleCell.h"
#import "QGLoginBottomBtnTableViewCell.h"
#import "QGBottomLittleBtnTableViewCell.h"
#import "QGLoginProtocolCell.h"
#import "QGLoginBottomView.h"

//Model
#import "QGAppleInfoModel.h"

#import <AuthenticationServices/AuthenticationServices.h>
@interface QGRegisterViewController ()<UITextViewDelegate, ASAuthorizationControllerDelegate, ASAuthorizationControllerPresentationContextProviding>
///header
@property (nonatomic, strong)UIView *tableHeaderView;

///用于记录输入的手机号
@property (nonatomic, copy)NSString *phoneString;

///用于修改底部按钮的可点击状态
@property (nonatomic, copy)void(^changeButtonStatus)(BOOL ableClick);

///是否已同意用户协议
@property (assign, nonatomic) BOOL isSelect;

/// 微信登录模型
@property (nonatomic, strong) QGWechatLoginInfoModel * wechatInfoModel;

/// apple登录模型
@property (nonatomic, strong) QGAppleInfoModel * appleInfoModel;
@end

@implementation QGRegisterViewController
-(BOOL)checkParameters:(NSDictionary *)param
{
    return YES;
}


- (void)viewDidLoad {
    [super viewDidLoad];
    [self initNormalUI];
}

- (void)initNormalUI
{
    //设置tableHeaderView
    UILabel *welcomeLabel = [UIView creatLabelWithSuperView:self.tableHeaderView title:@"欢迎使用真享生活" titleFontSize:[UIFont qg_regularFontOfSize:30] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
    [welcomeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.left.equalTo(self.tableHeaderView).inset(40);
        make.top.equalTo(self.tableHeaderView).inset(48);
        make.height.mas_equalTo(30);
    }];
    self.tableView.tableHeaderView = self.tableHeaderView;
    self.tableView.bounces = NO;
    @weakify(self);
    [self customLeftBarButtonItemWithImgName:@"vc_close" action:^(UIButton * _Nonnull button) {
           @strongify(self);
           [self dismissViewControllerAnimated:YES completion:nil];
           if (self.callBackBlock) {
               self.callBackBlock(LoginTag_QGMainLoginViewController_LoginCancle, nil);
           }
    }];
    
    
    //底部三方登录
    QGLoginBottomView * bottomView = [[QGLoginBottomView alloc] init];
    [self.view addSubview:bottomView];
    [bottomView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.bottom.inset(0);
        make.height.mas_equalTo(110 + [DeviceAdaptation getBottomSafeAreaHeight]);
    }];
    
    //点击事件
    bottomView.clickBlock = ^(QGLoginType type) {
        @strongify(self);
        switch (type) {
                ///微信登录
            case QGLoginTypeWechat:
                [self signInWithWechat];
                break;
                ///apple登录
            case QGLoginTypeApple:
            {
                if (@available(iOS 13.0, *)) {
                    [self signInWithApple];
                }
            }
            break;
                
            default:
                break;
        }
    };
}

#pragma mark - Reqeust

/// 检测微信是否绑定
- (void)checkWechatBinding
{
    if ([NSString isEmpty:self.wechatInfoModel.unionid]) {
        return;
    }
    
    NSString * urlString = [QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodCheckWechatBinding];
//    urlString = @"http://yapi.quantgroups.com/mock/305/vcc/external/login/weChat_opId";
    NSDictionary * infoDic = @{@"unionId":self.wechatInfoModel.unionid};
    [QGHUDManager showHud:nil];
    [[QGTalosNetwork shareManager] POST:urlString parameters:infoDic success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        //请求成功
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary * dataDic = responseObject[@"data"];
            //0:未绑定，1：已绑定
            BOOL checkStatus = [dataDic[@"checkStatus"] boolValue];
            //已绑定
            if (checkStatus){
                //保存登录信息
                [self loginSuccessSaveUserInfo:dataDic[@"loginInfo"]];
                //关闭页面
                [self performSelector:@selector(dismissPressed) withObject:nil afterDelay:0.2];
            }
            //未绑定
            else
            {
                [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGBindingPhoneViewController) parameters:@{@"wechatInfoModel":self.wechatInfoModel} handlerBlock:nil];
            }
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
    }];
    
}


- (void)checkAppleBinding
{
    NSString * urlString = [QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodCheckAppleBinding];
//    urlString = @"http://yapi.quantgroups.com/mock/305/vcc/external/login/apple_idtoken";
    [QGHUDManager showHud:nil];
    NSDictionary * infoDic = @{@"identityToken" : self.appleInfoModel.identityToken,
                               @"authorizationCode" : self.appleInfoModel.authorizationCode,
                               @"appleUserId" : self.appleInfoModel.userID
                                };
    [QGHUDManager showHud:nil];
    [[QGTalosNetwork shareManager] POST:urlString parameters:infoDic success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        //请求成功
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary * dataDic = responseObject[@"data"];
            //0:未绑定，1：已绑定 2 :校验未通过
            NSInteger checkStatus = [dataDic[@"checkStatus"] integerValue];
            //未绑定
            if (checkStatus == 0)
            {
                [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGBindingPhoneViewController) parameters:@{@"appleInfoModel":self.appleInfoModel} handlerBlock:nil];
            }
            //已绑定
            else if (checkStatus == 1){
                //保存登录信息
                [self loginSuccessSaveUserInfo:dataDic[@"loginInfo"]];
                //关闭页面
                [self performSelector:@selector(dismissPressed) withObject:nil afterDelay:0.2];
            }
            //未通过
            else if(checkStatus == 2)
            {
                [QGHUDManager showHud:@"Apple ID登录失效"];
            }
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
    }];;
}


#pragma mark - UITableViewDataSource

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return 4;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    __weak typeof(self)weakSelf = self;
    switch (indexPath.row) {
        case 0:
        {
            
            
            QGPhoneInputWithTitleCell *cell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([QGPhoneInputWithTitleCell class])];
            if (!cell) {
               cell = [[QGPhoneInputWithTitleCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"phonecell" cellTitle:@"手机号码" placeHolder:@"请输入手机号码"];
            }
            
            cell.phoneNumberinput.textField.text = self.phoneString;
            cell.padding = 40.f;
            @weakify(self)
            cell.cellBlock = ^(NSString *phoneNumber) {
                @strongify(self)
                self.phoneString = phoneNumber;
                
                if (self.phoneString.isNumber && self.phoneString.length == 11) {
                    self.changeButtonStatus(YES);
                }else{
                    self.changeButtonStatus(NO);
                }
                
            };
            
            return cell;
            
        }
            
        //协议
        case 1:
        {
            QGLoginProtocolCell * cell = (QGLoginProtocolCell *)[self getCellFromClassName:NSStringFromClass([QGLoginProtocolCell class]) dequeueTableView:tableView];
            cell.isAgree = self.isSelect;
            
            @weakify(self);
            //注册协议
            cell.registerProtocolClick = ^{
                @strongify(self);
                [self navigationToWeb:VCCRegisterAgreement];
            };
            
            //隐私协议
            cell.privacyProtocolClick = ^{
                @strongify(self);
                [self navigationToWeb:VCCPrivacyAgreement];
            };
            
            //同意协议
            cell.agressClick = ^{
                self.isSelect = !self.isSelect;
            };
            
            return cell;
        }
            break;
        case 2:
        {
            QGLoginBottomBtnTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([QGLoginBottomBtnTableViewCell class])];
            if (!cell) {
                cell = [[QGLoginBottomBtnTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"passwordCell" btnTitle:@"注册/登录" padding:40];
            }
            
            @weakify(self);
            cell.cellBlock = ^(UIButton *nextBtn) {//获取验证码，成功以后跳转页面
                @strongify(self);
                if (!self.isSelect) {
                    [QGHUDManager showHud:@"请您仔细阅读并同意相关协议"];
                    return;
                }
                
                [weakSelf.view endEditing:YES];
                [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGMessageRegisterOrLoginViewController] isPush:YES animation:YES parameters:@{@"phoneNumberStr":weakSelf.phoneString} handlerBlock:weakSelf.callBackBlock];
                
            };
            
            self.changeButtonStatus = ^(BOOL ableClick) {
                //设置按钮的点击状态
                [cell.loginButton setGradientButtonIsClickEnabled:ableClick];
            };
            
            if (self.phoneString.isNumber && self.phoneString.length == 11) {
                [cell.loginButton setGradientButtonIsClickEnabled:YES];
            }
            
            return cell;
        }
        case 3:
        {
            QGBottomLittleBtnTableViewCell *cell = [[QGBottomLittleBtnTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"little" leftBtnTitle:@"密码登录" rightBtnTitle:nil];
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            
            cell.cellBlock = ^(LittleBtnType btnType) {//处理按钮点击逻辑
                
                switch (btnType) {
                    case LittleBtnPasswordLogin://密码登录
                    {
                        //密码登录页面跳转
                        [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGPasswordLoginViewController] parameters:@{@"phone":IsStringNull(self.phoneString)} handlerBlock:^(NSString *tag, NSDictionary *parameters) {
                            
                            if ([tag isEqualToString:LoginTag_QGLoginViewController_ChangePhoneNum]) {
                                self.phoneString = [parameters valueForKey:@"phone"];
                                [self.tableView reloadData];
                            }
                            else
                            {
                                if (self.callBackBlock) {
                                    self.callBackBlock(tag, parameters);
                                }
                            }
                        }];
                    }
                        break;
                    default:
                        break;
                }
                
            };
            
            return cell;
        }
            
        default:
            return [UITableViewCell new];
    }
}

#pragma mark - UITableViewDelegate


-(CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row == 1) {
        return [QGLoginProtocolCell cellHeight];
    }
    else if (indexPath.row == 2) {
        return 40.f;
    }else if (indexPath.row == 3){
        return 60.f;
    }else {
        return 81;
    }
}


-(UIView *)tableHeaderView
{
    if (!_tableHeaderView) {
        _tableHeaderView = [[UIView alloc]init];
        _tableHeaderView.backgroundColor = [UIColor whiteColor];
        _tableHeaderView.bounds = CGRectMake(0, 0, MAINSCREEN_WIDTH, 140);
        
    }
    return _tableHeaderView;
}

#pragma mark - Action
//登录完成后取消当前页面
- (void)dismissPressed
{
    [self.view endEditing:YES];
    
    [self.navigationController dismissViewControllerAnimated:NO completion:^{
        if (self.callBackBlock) {
            self.callBackBlock(LoginTag_QGMainLoginViewController_LoginSuccess, nil);
        }
    }];
}

//完成登录并回调
- (void)loginSuccessSaveUserInfo:(NSDictionary *)responseObject
{
    
    if ([responseObject valueForKey:@"token"]) {
        [QGAnalyticsService analyticsLoginWithUUID:[responseObject objectForKey:@"uuid"]];
        [QGHUDManager showHud:@"登录成功"];
        [QGUserInfo sharedUserInfo].hasPassword = [[responseObject objectForKey:@"hasPassword"] boolValue];
        [QGUserInfo sharedUserInfo].userName = responseObject[@"phoneNo"];
        [QGUserInfo sharedUserInfo].token = [responseObject objectForKey:@"token"];
        [QGUserInfo sharedUserInfo].uuid = [responseObject objectForKey:@"uuid"];
        [QGUserInfo sharedUserInfo].vccRefreshToken = [responseObject objectForKey:@"vccRefreshToken"];
        [QGUserInfo sharedUserInfo].userId = [NSString stringWithFormat:@"%@", responseObject[@"userId"]];
        [QGUserInfo sharedUserInfo].alimamaAuth = [responseObject[@"alimamaAuth"] boolValue];
        [QGUserInfo sharedUserInfo].login = YES;
        [QGPushService setPushAccount:[QGUserInfo sharedUserInfo].userId];
        [[NSNotificationCenter defaultCenter] postNotificationName:ModelCenterUserLoginNotification object:nil];
    }
}

#pragma mark - 微信登录

/// 微信登录
- (void)signInWithWechat
{
    @weakify(self);
    //微信登录
    [[QGThirdPlatformService shareInstance] wxAuthWithSuccess:^(QGWechatLoginInfoModel *infoModel) {
        @strongify(self);
        self.wechatInfoModel = infoModel;
        [self checkWechatBinding];
    }];
}

#pragma mark - Apple登录
///AppleID登录
- (void)signInWithApple API_AVAILABLE(ios(13.0))
{
    //创建授权请求
    ASAuthorizationAppleIDProvider *provider = [[ASAuthorizationAppleIDProvider alloc] init];
    ASAuthorizationAppleIDRequest * request = [provider createRequest];
    //在用户授权期间请求的联系信息
    request.requestedScopes = @[ASAuthorizationScopeFullName];
    
    //弹出授权页面
    ASAuthorizationController *vc = [[ASAuthorizationController alloc] initWithAuthorizationRequests:@[request]];
    vc.delegate = self;
    vc.presentationContextProvider = self;
    [vc performRequests];
}

#pragma mark - ASAuthorizationControllerPresentationContextProviding
///设置展示的window层级
- (ASPresentationAnchor)presentationAnchorForAuthorizationController:(ASAuthorizationController *)controller API_AVAILABLE(ios(13.0))
{
    return self.view.window;
}

#pragma mark - ASAuthorizationControllerDelegate
- (void)authorizationController:(ASAuthorizationController *)controller didCompleteWithAuthorization:(ASAuthorization *)authorization API_AVAILABLE(ios(13.0))
{
    if ([authorization.credential isKindOfClass:[ASAuthorizationAppleIDCredential class]])       {
        ASAuthorizationAppleIDCredential *credential = authorization.credential;
        //苹果用户唯一标识，同一开发者账号下的APP获取到是一样的
        NSString *userID = credential.user;
//        NSPersonNameComponents *fullName = credential.fullName;
        //验证数据，传给后台
        NSString *authorizationCode = [[NSString alloc] initWithData:credential.authorizationCode encoding:NSUTF8StringEncoding];
        NSString *identityToken = [[NSString alloc] initWithData:credential.identityToken encoding:NSUTF8StringEncoding];
        
//        NSLog(@"userID: %@", userID);
//        NSLog(@"fullName: %@", fullName);
//        NSLog(@"authorizationCode: %@", authorizationCode);
//        NSLog(@"identityToken: %@", identityToken);
        self.appleInfoModel = [[QGAppleInfoModel alloc] init];
        self.appleInfoModel.userID = userID;
        self.appleInfoModel.authorizationCode = authorizationCode;
        self.appleInfoModel.identityToken = identityToken;
        [self checkAppleBinding];
    }
}

- (void)authorizationController:(ASAuthorizationController *)controller didCompleteWithError:(NSError *)error API_AVAILABLE(ios(13.0))
{
    NSString *errorMsg = nil;
    switch (error.code) {
        case ASAuthorizationErrorCanceled:
            errorMsg = @"用户取消了授权请求";
            break;
        case ASAuthorizationErrorFailed:
            errorMsg = @"授权请求失败";
            break;
        case ASAuthorizationErrorInvalidResponse:
            errorMsg = @"授权请求响应无效";
            break;
        case ASAuthorizationErrorNotHandled:
            errorMsg = @"未能处理授权请求";
            break;
        case ASAuthorizationErrorUnknown:
            errorMsg = @"授权请求失败未知原因";
            break;
    }
    NSLog(@"%@", errorMsg);
}



@end
