//
//  QGMessageRegisterOrLoginViewController.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/18.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGMessageRegisterOrLoginViewController.h"
#import "QGBasicUITool.h"
#import "QGMessageVerifyHeaderTableViewCell.h"
#import "QGVerifyCodeTableViewCell.h"
#import "QGMessageVerifyBottomTableViewCell.h"
#import "QGCountDown.h"
#import "QGLoginRequestApi.h"
#import "QGSendMessageCodeManger.h"
#import "QGCalendarManager.h"
#import "QGLoginRequestApi.h"
#import "QGPushService.h"

@interface QGMessageRegisterOrLoginViewController ()
///获取验证码cell
@property (nonatomic, strong)QGMessageVerifyBottomTableViewCell *cell;
///自定义定时器
@property (nonatomic, strong)QGCountDown *countDownTimer;
/// 倒计时剩余时间
@property (nonatomic, assign)NSInteger residueTime;
///输入的验证码
@property (nonatomic, copy)NSString *verifyCode;
///获取短信验证码管理类
@property (nonatomic, strong)QGSendMessageCodeManger *sendVerifyCodeManger;

///注册手机号
@property (nonatomic, copy)NSString *phoneNumberStr;
@end

@implementation QGMessageRegisterOrLoginViewController
-(BOOL)checkParameters:(NSDictionary *)param
{
    if ([[param objectForKey:@"phoneNumberStr"] isNumber]) {
        return YES;
    }
    
    return NO;
}

- (void)transferParameters:(NSDictionary *)param {
    
    self.phoneNumberStr = [param objectForKey:@"phoneNumberStr"];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    

    //初始化剩余时间60秒
    self.residueTime = 60;
    //自定义定时器初始化
    self.countDownTimer = [[QGCountDown alloc]init];
    //初始化发送短信验证码管理类
    self.sendVerifyCodeManger = [[QGSendMessageCodeManger alloc] init];
    
    //点击注册登录埋点
    NSMutableDictionary *info = [[NSMutableDictionary alloc] init];
    [info setObject:@"APP注册" forKey:@"abse_page_name"];
    [info setObject:@"点击注册登录" forKey:@"abse_action_name"];
    [info setObject:@"success" forKey:@"abse_state_value"];
    [QGAnalyticsService analyticsTrack:@"AppBusinessStateEvent" withProperties: info];
    
    
    __weak typeof(self) weakSelf = self;
    [self.sendVerifyCodeManger sendMessageCodeWithPhoneNumber:self.phoneNumberStr success:^{
        [weakSelf fireTimer];
    } fail:^{
        [weakSelf.cell.getCodeBtn setTitle:@"重新发送" forState:UIControlStateNormal];
        [weakSelf.cell.getCodeBtn setTitleColor:[UIColor textColor3333] forState:UIControlStateNormal];
        weakSelf.cell.getCodeBtn.userInteractionEnabled = YES;
    }];
    
}

//-(void)viewDidAppear:(BOOL)animated
//{
//    //启动定时器
//    [self fireTimer];
//
//    [self.sendVerifyCodeManger sendMessageCodeWithPhoneNumber:self.phoneNumberStr success:nil fail:nil];
//
//}

//登录验证码校验
-(void)checkVerifyCodeRequest
{
        
    [QGHUDManager showHud:nil];
    
    NSString *urlStr = [QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodLoginCheckSms];
    [[QGTalosNetwork shareManager] POST:urlStr parameters:@{@"loginName":self.phoneNumberStr,@"smsCode":self.verifyCode} success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        //业务处理成功
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            //短验登陆成功
            NSMutableDictionary *info = [[NSMutableDictionary alloc] init];
            [info setObject:@"APP注册" forKey:@"abse_page_name"];
            [info setObject:@"验证码登录" forKey:@"abse_action_name"];
            [info setObject:@"success" forKey:@"abse_state_value"];
            [QGAnalyticsService analyticsTrack:@"AppBusinessStateEvent" withProperties: info];
            
            NSDictionary * dataDic = responseObject[@"data"];
            //保存登录信息
            [self loginSuccessSaveUserInfo:dataDic];
            //关闭页面
            [self performSelector:@selector(dismissPressed) withObject:nil afterDelay:0.2];
            
        }
        //业务处理失败
        else
        {
            [QGHUDManager showHudWithError:responseObject];
            self.cell.promptLabel.hidden = NO;
        }
        
        
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
        self.cell.promptLabel.hidden = NO;
    }];
}


//完成登录并回调
- (void)loginSuccessSaveUserInfo:(NSDictionary *)responseObject
{
    
    if ([responseObject valueForKey:@"token"]) {
        [QGAnalyticsService analyticsLoginWithUUID:[responseObject objectForKey:@"uuid"]];
        [QGHUDManager showHud:@"登录成功"];
        [QGUserInfo sharedUserInfo].hasPassword = [[responseObject objectForKey:@"hasPassword"] boolValue];
        [QGUserInfo sharedUserInfo].userName = responseObject[@"phoneNo"];
        [QGUserInfo sharedUserInfo].token = [responseObject objectForKey:@"token"];
        [QGUserInfo sharedUserInfo].uuid = [responseObject objectForKey:@"uuid"];
        [QGUserInfo sharedUserInfo].vccRefreshToken = [responseObject objectForKey:@"vccRefreshToken"];
        [QGUserInfo sharedUserInfo].userId = [NSString stringWithFormat:@"%@", responseObject[@"userId"]];
        [QGUserInfo sharedUserInfo].alimamaAuth = [responseObject[@"alimamaAuth"] boolValue];
        [QGUserInfo sharedUserInfo].login = YES;
        [QGPushService setPushAccount:[QGUserInfo sharedUserInfo].userId];
        [[NSNotificationCenter defaultCenter] postNotificationName:ModelCenterUserLoginNotification object:nil];
    }
}

//登录完成后取消当前页面
- (void)dismissPressed
{
    [self.view endEditing:YES];
    [self.navigationController dismissViewControllerAnimated:NO
                             completion:^{
                                 if (self.callBackBlock) {
                                     self.callBackBlock(LoginTag_QGMainLoginViewController_LoginSuccess, nil);
                                 }
                             }];
}

//启动定时器
-(void)fireTimer
{
    [self.countDownTimer countDownWithPER_SECBlock:^{
        self.residueTime--;
        if (self.residueTime == 0) {
            [self.countDownTimer destoryTimer];
            self.residueTime = 60;
            [self.cell.getCodeBtn setTitle:@"重新发送" forState:UIControlStateNormal];
            [self.cell.getCodeBtn setTitleColor:[UIColor textColor3333] forState:UIControlStateNormal];
            self.cell.getCodeBtn.userInteractionEnabled = YES;
        }else{
            
            [self.cell.getCodeBtn setTitle:[NSString stringWithFormat:@"%ld 秒后重新获取验证码",(long)self.residueTime] forState:UIControlStateNormal];

            
        }
    }];
}

-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 3;
}

-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row == 0) {
        QGMessageVerifyHeaderTableViewCell *cell = (QGMessageVerifyHeaderTableViewCell *)[self getCellFromClassName:NSStringFromClass([QGMessageVerifyHeaderTableViewCell class]) dequeueTableView:tableView];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.subtitleLabel.text = [NSString stringWithFormat:@"验证码已发送至 %@",self.phoneNumberStr];
        
        return cell;
    }else if (indexPath.row == 1){
        QGVerifyCodeTableViewCell *cell = (QGVerifyCodeTableViewCell *)[self getCellFromClassName:NSStringFromClass([QGVerifyCodeTableViewCell class]) dequeueTableView:tableView];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        __weak typeof(self)weakSelf = self;
        [cell.verifyCodeView getInputVerifyCodeblock:^(NSString *code,BOOL complete) {
            weakSelf.verifyCode = code;
            ///验证码输入完成或者开始输入的回调
            if (!complete) {
                weakSelf.cell.promptLabel.hidden = YES;
            }else{
                [weakSelf checkVerifyCodeRequest];
            }
            
        }];
        
        return cell;
    }else{
        
        QGMessageVerifyBottomTableViewCell *cell = (QGMessageVerifyBottomTableViewCell *)[self getCellFromClassName:NSStringFromClass([QGMessageVerifyBottomTableViewCell class]) dequeueTableView:tableView];
        __weak typeof(self)weakSelf = self;
        cell.cellBlock = ^(UIButton *nextBtn) {
          //再次请求验证码
            [weakSelf.cell.getCodeBtn setTitleColor:[UIColor textColor9999] forState:UIControlStateNormal];
            weakSelf.cell.getCodeBtn.userInteractionEnabled = NO;
            [weakSelf.cell.getCodeBtn setTitle:@"60 秒后重新获取验证码" forState:UIControlStateNormal];
            [weakSelf fireTimer];

            [weakSelf.sendVerifyCodeManger sendMessageCodeWithPhoneNumber:weakSelf.phoneNumberStr success:nil fail:nil];
        };
        
        self.cell = cell;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;

        return cell;
    }
}

-(CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row == 0) {
        return 118;
    }else if (indexPath.row == 1){
        
        return 90;
    }
    
    return 59;

}


@end
