//
//  QGLoginBottomView.m
//  VirtualPayment
//
//  Created by 张博 on 2020/5/22.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGLoginBottomView.h"
#import "QGBasicUITool.h"
#import "ZHWeChatTool.h"
@implementation QGLoginBottomView

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        //微信未安装，不初始化下面UI
        if ([[ZHWeChatTool share] isWXInstalled]) {
            [self initNormalUI];
        }
    }
    return self;
}

//初始化UI
- (void)initNormalUI
{
    //线条
    UIView * lineView = [UIView creatViewWithSuperView:self backgroundColor:[UIColor lineSeparatorColorDCDC]];
    [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.inset(40);
        make.top.inset(10);
        make.height.mas_equalTo(0.5);
    }];
    
    //标题
    UILabel * titleLabel = [UILabel creatLabelWithSuperView:self title:@"第三方登录" titleFontSize:[UIFont qg_lightFontOfSize:12] textColor:[UIColor textColor9999] alignment:NSTextAlignmentCenter];
    titleLabel.backgroundColor = [UIColor whiteColor];
    [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.size.mas_equalTo(CGSizeMake(82, 17));
        make.centerX.offset(0);
        make.centerY.mas_equalTo(lineView);
    }];
    
    
    
    //微信登录
    QGLoginBottomCell * wechatCell = [[QGLoginBottomCell alloc] initWithIconImageName:@"login_wechat" title:@"微信登录"];
    [self addSubview:wechatCell];
    wechatCell.tag = QGLoginTypeWechat;
    [wechatCell addTarget:self action:@selector(loginButtonClick:) forControlEvents:UIControlEventTouchUpInside];
    
    
    //apple登录
    QGLoginBottomCell * appleCell = [[QGLoginBottomCell alloc] initWithIconImageName:@"login_apple" title:@"Apple登录"];
    [self addSubview:appleCell];
    appleCell.tag = QGLoginTypeApple;
    [appleCell addTarget:self action:@selector(loginButtonClick:) forControlEvents:UIControlEventTouchUpInside];
    
    
    //iOS13以上才有apple登录
    if (iOS13) {
        //微信登录
        [wechatCell mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.mas_equalTo(self.mas_centerX).multipliedBy(0.5);
            make.width.mas_equalTo(60);
            make.top.mas_equalTo(titleLabel.mas_bottom).offset(19);
        }];
        
        //apple登录
        [appleCell mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.mas_equalTo(self.mas_centerX).multipliedBy(1.5);
            make.width.mas_equalTo(60);
            make.top.mas_equalTo(titleLabel.mas_bottom).offset(19);
        }];
        
    }
    else
    {
        //微信登录
        [wechatCell mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.mas_equalTo(self.mas_centerX);
            make.width.mas_equalTo(60);
            make.top.mas_equalTo(titleLabel.mas_bottom).offset(19);
        }];
        appleCell.hidden = YES;
    }
    
}


/// 登录按钮点击事件
- (void)loginButtonClick:(QGLoginBottomCell *)loginCell
{
    if (self.clickBlock) {
        self.clickBlock(loginCell.tag);
    }
}

@end




@implementation QGLoginBottomCell


/// 初始化方法
/// @param imageName 图标名称
/// @param title 标题
- (instancetype)initWithIconImageName:(NSString *)imageName title:(NSString *)title
{
    if (self = [super init]) {
        //图标
        self.iconImgView = [UIImageView creatImageViewWithSuperView:self imageName:imageName];
        [self.iconImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(40, 40));
            make.top.inset(0);
            make.centerX.offset(0);
        }];

        //标题
        self.titleLabel = [UILabel creatLabelWithSuperView:self title:title titleFontSize:[UIFont qg_lightFontOfSize:12] textColor:[UIColor textColor6666] alignment:NSTextAlignmentCenter];
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.mas_equalTo(self.iconImgView.mas_bottom).offset(5);
            make.height.mas_equalTo(17);
            make.centerX.offset(0);
            make.bottom.inset(0);
        }];
    }
    return self;
}



@end
