//
//  QGLoginBottomView.h
//  VirtualPayment
//
//  Created by 张博 on 2020/5/22.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>

typedef NS_ENUM(NSUInteger, QGLoginType) {
    QGLoginTypeWechat = 1,
    QGLoginTypeApple
};

///登录点击事件
typedef void(^QGLoginBottomViewClickBlock)(QGLoginType type);

NS_ASSUME_NONNULL_BEGIN

@interface QGLoginBottomView : UIView

/// 点击事件
@property (nonatomic, copy) QGLoginBottomViewClickBlock clickBlock;


@end



@interface QGLoginBottomCell : UIControl

/// 图标
@property (nonatomic, strong) UIImageView * iconImgView;

/// 标题
@property (nonatomic, strong) UILabel * titleLabel;


/// 初始化方法
/// @param imageName 图标名称
/// @param title 标题
- (instancetype)initWithIconImageName:(NSString *)imageName title:(NSString *)title;

@end

NS_ASSUME_NONNULL_END
