//
//  QGLoginTableViewCell.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/17.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGLoginTableViewCell.h"
#import "QGBasicUITool.h"

@interface QGLoginTableViewCell()

///分割线
@property (nonatomic, strong)UIView *phoneUnderLine;


@end
@implementation QGLoginTableViewCell

-(instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        
        [self.contentView addSubview:self.phoneNumberinput];
        self.phoneUnderLine = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor lineSeparatorColorDCDC]];

        [self.phoneNumberinput mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(self.contentView).offset(10);
            make.left.right.equalTo(self.contentView).inset(40);
            make.height.mas_equalTo(45);
        }];
        
        [self.phoneUnderLine mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(self.phoneNumberinput);
            make.top.equalTo(self.phoneNumberinput.mas_bottom).offset(7);
            make.height.mas_equalTo(0.5);
        }];
    }
    
    return self;
}



-(void)textFieldChange:(UITextField *)tx
{
    
    tx.text = [tx.text stringByReplacingOccurrencesOfString:@""  withString:@""];
    
    if (tx.text.length<=11) {
        if (self.cellBlock) {
            self.cellBlock(tx.text);
        }
    }else{
        tx.text = [tx.text substringWithRange:NSMakeRange(0, 11)];
        if (self.cellBlock) {
            self.cellBlock(tx.text);
        }
    }

}


-(QGInputGroupView *)phoneNumberinput
{
    if (!_phoneNumberinput) {
        _phoneNumberinput = [[QGInputGroupView alloc]initWithType:InputViewTypeText title:nil placeHolder:@"请输入手机号"];
        _phoneNumberinput.accessoryButton.hidden = YES;
        [_phoneNumberinput.textField addTarget:self action:@selector(textFieldChange:) forControlEvents:UIControlEventEditingChanged];
        _phoneNumberinput.textField.keyboardType = UIKeyboardTypeNumberPad;
    }
    return _phoneNumberinput;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
