//
//  QGLoginInputPasswordTableViewCell.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/17.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGLoginInputPasswordTableViewCell.h"
#import "QGInputGroupView.h"
#import "QGBasicUITool.h"
@interface QGLoginInputPasswordTableViewCell ()
@property (nonatomic, strong)QGInputGroupView *passwordInputView;
@property (nonatomic, strong)UIView *passwordUnderLine;
@end
@implementation QGLoginInputPasswordTableViewCell

-(instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        
        [self.contentView addSubview:self.passwordInputView];
        self.passwordUnderLine = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor lineSeparatorColorDCDC]];
        
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        [self.passwordInputView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(self.contentView).offset(10);
            make.left.right.equalTo(self.contentView).inset(40);
            make.height.mas_equalTo(45);
        }];
        
        [self.passwordUnderLine mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(self.passwordInputView);
            make.top.equalTo(self.passwordInputView.mas_bottom).offset(7);
            make.height.mas_equalTo(0.5);
        }];
        self.selectionStyle = UITableViewCellSelectionStyleNone;

    }
    
    return self;
}



-(void)textFieldChange:(UITextField *)tx
{
    if (self.cellBlock) {
        self.cellBlock(tx.text);
    }
}


-(QGInputGroupView *)passwordInputView
{
    if (!_passwordInputView) {
        _passwordInputView = [[QGInputGroupView alloc]initWithType:InputViewTypePwd title:nil placeHolder:@"请输入密码"];
        [_passwordInputView.textField addTarget:self action:@selector(textFieldChange:) forControlEvents:UIControlEventEditingChanged];
    }
    return _passwordInputView;
}

@end
