//
//  QGLoginResetPasswordViewController.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/19.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGLoginResetPasswordViewController.h"
#import "QGRegisterSetPasswordHeaderCell.h"
#import "QGLoginResetPasswordInputPhoneNumberCell.h"
#import "QGLoginBottomBtnTableViewCell.h"

@interface QGLoginResetPasswordViewController ()
@property (nonatomic, copy)NSString *phoneNumber;

@end

@implementation QGLoginResetPasswordViewController
-(BOOL)checkParameters:(NSDictionary *)param
{
    return YES;
}
- (void)viewDidLoad {
    [super viewDidLoad];
//    [self custemLeftDefaultBarButtonItem];
//    [self setIsBelowNavBar:NO];
//    [self setNavBarBottomLineHidden:YES];
    self.title = @"修改登录密码";
}


-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 3;
}

-(CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row == 0) {
        return 65;
    }else if (indexPath.row == 1){
        return 61;
    }else{
        return 85;
    }
}

-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row == 0) {
        QGRegisterSetPasswordHeaderCell *cell = [[QGRegisterSetPasswordHeaderCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"header"];
        cell.titleLabel.text = @"请输入要修改密码的账号";
        return cell;
    }else if (indexPath.row == 1){
        QGLoginResetPasswordInputPhoneNumberCell *cell = (QGLoginResetPasswordInputPhoneNumberCell *)[self getCellFromClassName:NSStringFromClass([QGLoginResetPasswordInputPhoneNumberCell class]) dequeueTableView:tableView];
        cell.cellBlock = ^(NSString *textStr) {
            self.phoneNumber = textStr;
        };
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        return cell;
    }else{
        
        QGLoginBottomBtnTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([QGLoginBottomBtnTableViewCell class])];
        if (!cell) {
            cell = [[QGLoginBottomBtnTableViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"bottom" btnTitle:@"下一步" padding:20];
        }
        
        [cell.loginButton setGradientButtonIsClickEnabled:YES];
        cell.cellBlock = ^(UIButton *nextBtn) {
            [self nextBtnSubmit:nextBtn];
        };
        
        return cell;
    }
}


-(void)nextBtnSubmit:(UIButton *)btn
{
    //处理下一步的跳转
    if (!self.phoneNumber.isNumber || self.phoneNumber.length != 11) {
        [QGHUDManager showHud:@"请输入正确的手机号"];
        return;
    }
    
    [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGLoginSelectResetPasswordTypeViewController] isPush:YES animation:YES parameters:@{@"phoneNumberStr":self.phoneNumber} handlerBlock:self.callBackBlock];
}



@end


