//
//  QGLoginResetPasswordInputPhoneNumberCell.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/19.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGLoginResetPasswordInputPhoneNumberCell.h"
#import "QGBasicUITool.h"
@implementation QGLoginResetPasswordInputPhoneNumberCell

-(instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        self.inputView = [[QGInputGroupView alloc]initWithType:InputViewTypeText title:nil placeHolder:@"请输入手机号"];
        self.inputView.accessoryButton.hidden = YES;
        self.inputView.textField.keyboardType = UIKeyboardTypeNumberPad;
        [self.inputView.textField addTarget:self action:@selector(textFieldChange:) forControlEvents:UIControlEventEditingChanged];

        
        [self.contentView addSubview:self.inputView];
        self.underLine = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor lineSeparatorColorDCDC]];
        
        [self.inputView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(self.contentView).offset(10);
            make.left.right.equalTo(self.contentView).inset(20);
            make.height.mas_equalTo(45);
        }];
        
        [self.underLine mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(self.inputView);
            make.top.equalTo(self.inputView.mas_bottom).offset(7);
            make.height.mas_equalTo(0.5);
        }];
    }
    
    return self;
}



-(void)textFieldChange:(UITextField *)tx
{
    
    NSString *phone = [tx.text stringByReplacingOccurrencesOfString:@" " withString:@""];
    tx.text = phone;
    if (self.cellBlock) {
        self.cellBlock(phone);
    }
}


@end
