//
//  QGBindingPhoneViewController.m
//  VirtualPayment
//
//  Created by 张博 on 2020/5/22.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGBindingPhoneViewController.h"

//View
#import "QGLoginTableViewCell.h"
#import "QGLoginProtocolCell.h"
#import "QGLoginBottomBtnTableViewCell.h"
#import "QGBindingVerifyCodeCell.h"
#import "QGAlertView.h"

//Tool
#import "QGCountDown.h"
#import "QGSendMessageCodeManger.h"
#import "QGLoginRequestApi.h"
#import "QGPushService.h"

//Model
#import "ZHWeChatTool.h"
#import "QGAppleInfoModel.h"

@interface QGBindingPhoneViewController ()

///手机号
@property (nonatomic, copy)NSString * phoneString;

///验证码
@property (nonatomic, copy)NSString * verifyCodeString;

///登录按钮是否可点击的设置
@property (nonatomic, copy) void (^changeButtonStatus) (BOOL ableClick);

///是否已同意用户协议
@property (assign, nonatomic) BOOL isSelect;

///自定义tableView header
@property (nonatomic, strong) UIView * tableHeaderView;

/// 验证码按钮
@property (nonatomic, strong) UIButton * codeButton;

///自定义定时器
@property (nonatomic, strong) QGCountDown * countDownTimer;

/// 倒计时剩余时间
@property (nonatomic, assign) NSInteger residueTime;

///获取短信验证码管理类
@property (nonatomic, strong) QGSendMessageCodeManger * sendVerifyCodeManger;

/// 微信用户信息
@property (nonatomic, strong) QGWechatLoginInfoModel * wechatInfoModel;

/// 苹果用户信息
@property (nonatomic, strong) QGAppleInfoModel * appleInfoModel;
@end

@implementation QGBindingPhoneViewController

- (BOOL)checkParameters:(NSDictionary *)param
{
    if (param[@"wechatInfoModel"] || param[@"appleInfoModel"]) {
        return YES;
    }
    return NO;
}

- (void)transferParameters:(NSDictionary *)param
{
    self.wechatInfoModel = param[@"wechatInfoModel"];
    self.appleInfoModel = param[@"appleInfoModel"];
}


- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    //初始化剩余时间60秒
    self.residueTime = 60;
    //自定义定时器初始化
    self.countDownTimer = [[QGCountDown alloc]init];
    //初始化发送短信验证码管理类
    self.sendVerifyCodeManger = [[QGSendMessageCodeManger alloc] init];
    
    self.tableView.bounces = NO;
    
    //设置tableview的header
    UILabel *welcomeLabel = [UIView creatLabelWithSuperView:self.tableHeaderView title:@"请绑定手机号" titleFontSize:[UIFont qg_regularFontOfSize:30] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
    [welcomeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.left.equalTo(self.tableHeaderView).inset(40);
        make.top.equalTo(self.tableHeaderView).inset(48);
        make.height.mas_equalTo(30);
    }];
    self.tableView.tableHeaderView = self.tableHeaderView;
}


#pragma mark - Request
//微信登录验证码校验
-(void)wechatCheckVerifyCodeRequest
{
    NSString *urlStr = [QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodLoginWechat];
    NSMutableDictionary * infoDic = [NSMutableDictionary dictionaryWithCapacity:0];
    [infoDic setObject:IsStringNull(self.phoneString) forKey:@"loginName"];
    [infoDic setObject:IsStringNull(self.verifyCodeString) forKey:@"smsCode"];
    
    [infoDic setObject:IsStringNull(self.wechatInfoModel.openid) forKey:@"openId"];
    [infoDic setObject:IsStringNull(self.wechatInfoModel.unionid) forKey:@"unionId"];
    [infoDic setObject:IsStringNull(self.wechatInfoModel.nickname) forKey:@"nickName"];
    [infoDic setObject:IsStringNull(self.wechatInfoModel.headimgurl) forKey:@"headImgUrl"];
    [infoDic setObject:IsStringNull(self.wechatInfoModel.sex) forKey:@"sex"];

    [QGHUDManager showHud:nil];
    [[QGTalosNetwork shareManager] POST:urlStr parameters:infoDic success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        //业务处理成功
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            //短验登陆成功
            NSMutableDictionary *info = [[NSMutableDictionary alloc] init];
            [info setObject:@"APP注册" forKey:@"abse_page_name"];
            [info setObject:@"验证码登录" forKey:@"abse_action_name"];
            [info setObject:@"success" forKey:@"abse_state_value"];
            [QGAnalyticsService analyticsTrack:@"AppBusinessStateEvent" withProperties: info];
            
            NSDictionary * dataDic = responseObject[@"data"];
            //保存登录信息
            [self loginSuccessSaveUserInfo:dataDic];
            //关闭页面
            [self performSelector:@selector(dismissPressed) withObject:nil afterDelay:0.2];
            
        }
        //弹窗处理
        else if ([responseObject[@"businessCode"] isEqualToString:@"1010"])
        {
            QGAlertView * alertView = [[QGAlertView alloc] initWithTitle:nil message:@"该手机号已绑定其他微信账号" cancelButtonTitle:nil sureButtonTitle:@"知道了" clickBlock:nil];
            [alertView showInView:nil];
        }
        //业务处理失败
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }

    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
    }];
}


//apple登录验证码校验
-(void)appleCheckVerifyCodeRequest
{
    NSString *urlStr = [QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodLoginApple];
    NSMutableDictionary * infoDic = [NSMutableDictionary dictionaryWithCapacity:0];
    [infoDic setObject:IsStringNull(self.phoneString) forKey:@"loginName"];
    [infoDic setObject:IsStringNull(self.verifyCodeString) forKey:@"smsCode"];
    
    [infoDic setObject:IsStringNull(self.appleInfoModel.userID) forKey:@"appleUserId"];
//    [infoDic setObject:IsStringNull(self.appleInfoModel.fullName) forKey:@"appleFullName"];
    [infoDic setObject:IsStringNull(self.appleInfoModel.identityToken) forKey:@"identityToken"];

    [QGHUDManager showHud:nil];
    [[QGTalosNetwork shareManager] POST:urlStr parameters:infoDic success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        //业务处理成功
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            //短验登陆成功
            NSMutableDictionary *info = [[NSMutableDictionary alloc] init];
            [info setObject:@"APP注册" forKey:@"abse_page_name"];
            [info setObject:@"验证码登录" forKey:@"abse_action_name"];
            [info setObject:@"success" forKey:@"abse_state_value"];
            [QGAnalyticsService analyticsTrack:@"AppBusinessStateEvent" withProperties: info];
            
            NSDictionary * dataDic = responseObject[@"data"];
            //保存登录信息
            [self loginSuccessSaveUserInfo:dataDic];
            //关闭页面
            [self performSelector:@selector(dismissPressed) withObject:nil afterDelay:0.2];
            
        }
        //弹窗处理
        else if ([responseObject[@"businessCode"] isEqualToString:@"1010"])
        {
            QGAlertView * alertView = [[QGAlertView alloc] initWithTitle:nil message:@"该手机号已绑定其他Apple账号" cancelButtonTitle:nil sureButtonTitle:@"知道了" clickBlock:nil];
            [alertView showInView:nil];
        }
        //业务处理失败
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }

    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
    }];
}





//完成登录并回调
- (void)loginSuccessSaveUserInfo:(NSDictionary *)responseObject
{
    
    if ([responseObject valueForKey:@"token"]) {
        [QGAnalyticsService analyticsLoginWithUUID:[responseObject objectForKey:@"uuid"]];
        [QGHUDManager showHud:@"登录成功"];
        [QGUserInfo sharedUserInfo].hasPassword = [[responseObject objectForKey:@"hasPassword"] boolValue];
        [QGUserInfo sharedUserInfo].userName = responseObject[@"phoneNo"];
        [QGUserInfo sharedUserInfo].token = [responseObject objectForKey:@"token"];
        [QGUserInfo sharedUserInfo].uuid = [responseObject objectForKey:@"uuid"];
        [QGUserInfo sharedUserInfo].vccRefreshToken = [responseObject objectForKey:@"vccRefreshToken"];
        [QGUserInfo sharedUserInfo].userId = [NSString stringWithFormat:@"%@", responseObject[@"userId"]];
        [QGUserInfo sharedUserInfo].alimamaAuth = [responseObject[@"alimamaAuth"] boolValue];
        [QGUserInfo sharedUserInfo].login = YES;
        [QGPushService setPushAccount:[QGUserInfo sharedUserInfo].userId];
        [[NSNotificationCenter defaultCenter] postNotificationName:ModelCenterUserLoginNotification object:nil];
    }
}

//登录完成后取消当前页面
- (void)dismissPressed
{
    [self.view endEditing:YES];
    [self.navigationController dismissViewControllerAnimated:NO completion:^{
         if (self.callBackBlock) {
             self.callBackBlock(LoginTag_QGMainLoginViewController_LoginSuccess, nil);
         }
     }];
}


#pragma mark - UITableViewDataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 4;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    switch (indexPath.row) {
            //手机号输入框
        case 0:
        {
            QGLoginTableViewCell *cell = (QGLoginTableViewCell *)[self getCellFromClassName:NSStringFromClass([QGLoginTableViewCell class]) dequeueTableView:tableView];
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            @weakify(self)
            cell.phoneNumberinput.textField.text = self.phoneString;
            cell.cellBlock = ^(NSString *phoneNumber) {
                @strongify(self)
                self.phoneString = phoneNumber;
                if (self.callBackBlock) {
                    self.callBackBlock(LoginTag_QGLoginViewController_ChangePhoneNum, @{@"phone":self.phoneString});
                }
                
                if (self.phoneString.isNumber && self.phoneString.length == 11 && ![NSString isEmpty:self.verifyCodeString]) {
                    //登录按钮可点击
                    self.changeButtonStatus(YES);
                } else {
                    //登录按钮不可点击
                    self.changeButtonStatus(NO);
                }
            };
            
            return cell;
        
        }
            break;
            //验证码输入框
        case 1:
        {
            QGBindingVerifyCodeCell * cell = (QGBindingVerifyCodeCell *)[self getCellFromClassName:NSStringFromClass([QGBindingVerifyCodeCell class]) dequeueTableView:tableView];
            @weakify(self);
            cell.cellBlock = ^(NSString * _Nonnull codeNumber) {
                @strongify(self);
                self.verifyCodeString = codeNumber;
                if (self.phoneString.isNumber && self.phoneString.length == 11 && ![NSString isEmpty:self.verifyCodeString]) {
                    //登录按钮可点击
                    self.changeButtonStatus(YES);
                } else {
                    //登录按钮不可点击
                    self.changeButtonStatus(NO);
                }
            };
            
            //验证码点击事件
            [cell.codeButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
                @strongify(self);
                [self codeButtonClick];
            }];
            
            //标记按钮，用于计时器逻辑
            self.codeButton = cell.codeButton;
            return cell;
        }
            break;
            //协议
        case 2:
        {
            QGLoginProtocolCell * cell = (QGLoginProtocolCell *)[self getCellFromClassName:NSStringFromClass([QGLoginProtocolCell class]) dequeueTableView:tableView];
            cell.isAgree = self.isSelect;
            
            @weakify(self);
            //注册协议
            cell.registerProtocolClick = ^{
                @strongify(self);
                [self navigationToWeb:VCCRegisterAgreement];
            };
            
            //隐私协议
            cell.privacyProtocolClick = ^{
                @strongify(self);
                [self navigationToWeb:VCCPrivacyAgreement];
            };
            
            //同意协议
            cell.agressClick = ^{
                @strongify(self);
                self.isSelect = !self.isSelect;
            };
            
            return cell;
        }
            break;
            //登录按钮
        case 3:
        {
            QGLoginBottomBtnTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([QGLoginBottomBtnTableViewCell class])];
            if (!cell) {
                cell = [[QGLoginBottomBtnTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:NSStringFromClass([QGLoginBottomBtnTableViewCell class]) btnTitle:@"登录" padding:40];
            }
            @weakify(self);
            cell.cellBlock = ^(UIButton *nextBtn) {
                @strongify(self);
                //登录按钮点击事件
                [self submitBtnClick:nextBtn];
            };
            
            self.changeButtonStatus = ^(BOOL ableClick) {
                [cell.loginButton setGradientButtonIsClickEnabled:ableClick];
            };
            
            return cell;
        }
            break;
    }
    return [UITableViewCell new];
}


#pragma mark - UITableViewDelegate
-(CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row == 2) {
        return [QGLoginProtocolCell cellHeight];
    }
    else if (indexPath.row == 3) {
        return 40.f;
    }else {
        return 63.f;
    }
}

#pragma mark - Getter
-(UIView *)tableHeaderView
{
    if (!_tableHeaderView) {
        _tableHeaderView = [[UIView alloc]init];
        _tableHeaderView.backgroundColor = [UIColor whiteColor];
        _tableHeaderView.bounds = CGRectMake(0, 0, MAINSCREEN_WIDTH, 140);
        
    }
    return _tableHeaderView;
}


#pragma mark - Action
//登录按钮点击提交用户名密码
- (void)submitBtnClick:(UIButton *)sender {
    
    if (!self.isSelect) {
        [QGHUDManager showHud:@"请您仔细阅读并同意相关协议"];
        return;
    }
    [self.view endEditing:YES];
    
    if (self.phoneString.length != 11 || !self.phoneString.isNumber) {
        [QGHUDManager showHud:@"手机号格式不正确"];
        return;
    }
    
    //绑定微信
    if (self.wechatInfoModel) {
        [self wechatCheckVerifyCodeRequest];
    }
    //绑定apple ID
    else if (self.appleInfoModel)
    {
        [self appleCheckVerifyCodeRequest];
    }
}





///验证码按钮点击事件
- (void)codeButtonClick
{
    if (self.phoneString.length != 11 || !self.phoneString.isNumber) {
        [QGHUDManager showHud:@"手机号格式不正确"];
        return;
    }
    
    //控制按钮状态
    self.codeButton.userInteractionEnabled = NO;
    [self.codeButton setTitleColor:[UIColor textColor9999] forState:UIControlStateNormal];
    //开启定时器
    [self fireTimer];
    
    //发送验证码
    [self.sendVerifyCodeManger sendMessageCodeWithPhoneNumber:self.phoneString success:nil fail:nil];
    
}

//启动定时器
-(void)fireTimer
{
    [self.countDownTimer countDownWithPER_SECBlock:^{
        self.residueTime--;
        if (self.residueTime == 0) {
            [self.countDownTimer destoryTimer];
            self.residueTime = 60;
            [self.codeButton setTitle:@"重新发送" forState:UIControlStateNormal];
            [self.codeButton setTitleColor:[UIColor textColor3333] forState:UIControlStateNormal];
            self.codeButton.userInteractionEnabled = YES;
        }else{
            [self.codeButton setTitle:[NSString stringWithFormat:@"%lds",(long)self.residueTime] forState:UIControlStateNormal];
        }
    }];
}

@end
