//
//  QGLoginProtocolCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/1/16.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGLoginProtocolCell.h"
#import "QGBasicUITool.h"
#import "ZHAttributedLabelTool.h"
#import "ZHHitLabel.h"
@interface QGLoginProtocolCell () <UITextViewDelegate>


/// 协议承载视图
@property (nonatomic, strong) ZHHitLabel * protocolLabel;

@end


@implementation QGLoginProtocolCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        /// 协议承载视图
        self.protocolLabel = [[ZHHitLabel alloc] init];
        self.protocolLabel.numberOfLines = 0;
        [self.contentView addSubview:self.protocolLabel];
        [self.protocolLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(40);
            make.top.inset(30);
        }];
        
        
        
        //点击事件
        @weakify(self);
        self.protocolLabel.clickBlock = ^(ZHRichHelpModel *model) {
            @strongify(self);
            if ([model.valueStr containsString:@"用户注册协议"]) {
                if (self.registerProtocolClick) {
                    self.registerProtocolClick();
                }
            }
            else if ([model.valueStr containsString:@"隐私保护政策"])
            {
                if (self.privacyProtocolClick) {
                    self.privacyProtocolClick();
                }
            }
            else if ([model.valueStr containsString:@"我已阅读"])
            {
                if (self.agressClick) {
                    self.agressClick();
                }
                self.isAgree = !self.isAgree;
            }
        };
        
    }
    return self;
}

- (void)setIsAgree:(BOOL)isAgree
{
    _isAgree = isAgree;
    self.protocolLabel.attributedText = [[QGLoginProtocolCell protocolToolIsSelect:isAgree] getResultString];
}

+ (ZHAttributedLabelTool *)protocolToolIsSelect:(BOOL)select
{
    NSString * protocolString = @" 我已阅读并同意《用户注册协议》《隐私保护政策》";
    ZHAttributedLabelTool * protocolTool = [[ZHAttributedLabelTool alloc] initWithText:protocolString font:[UIFont qg_lightFontOfSize:12] color:[UIColor textColor6666]];
    
    //添加图片
    [protocolTool addAttachmentWithImageName:select == YES ? @"selected" : @"notSelect" index:0 size:CGRectMake(0, -2, 12, 12)];
    [protocolTool addRichHelpWithType:ZHRichHelpTypeClick range:NSMakeRange(0, 8) color:[UIColor textColor6666]];
    
    //用户注册协议
    NSRange userRegisterRange = [[protocolTool getResultString].string rangeOfString:@"《用户注册协议》"];
    [protocolTool addRichHelpWithType:ZHRichHelpTypeClick range:userRegisterRange color:[UIColor mainThemeColor]];
    
    //隐私保护政策
    NSRange privacyRange = [[protocolTool getResultString].string rangeOfString:@"《隐私保护政策》"];
    [protocolTool addRichHelpWithType:ZHRichHelpTypeClick range:privacyRange color:[UIColor mainThemeColor]];
    
    return protocolTool;
}

///cell高度
+ (CGFloat)cellHeight
{
    ZHAttributedLabelTool * protocolTool = [self protocolToolIsSelect:YES];
    return 30 + [protocolTool getSizeWithMaxWidth:MAINSCREEN_WIDTH - 80].height + 10;
}




@end
