//
//  QGInputVerifyCodeView.h
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/14.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>

@interface QGInputVerifyCodeView : UIView
/// 当前输入的内容(验证码)的回调
@property (nonatomic, copy) void(^codeBlock)(NSString *code,BOOL complete);

/**
 自定义验证码输入
 @param count 验证码个数
 @param itemWidth 文字和下划线的宽度
 @return 自定义view
 */
- (instancetype)initWithCount:(NSInteger)count itemWidth:(CGFloat)itemWidth;

//当前输入的内容(验证码)的回调,并返回view自身
-(instancetype)getInputVerifyCodeblock:(void(^)(NSString *code,BOOL complete))codeBlock;

@end
