//
//  QGCashbackViewController.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/11.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGCashbackViewController.h"

//View
#import "QGCashbackHeaderCell.h"
#import "QGCashbackIncomeCell.h"
#import "QGCashRuleEntranceCell.h"
#import "QGCashbackBannerCell.h"
#import "QGCashbackBrokenLineCell.h"
#import "QGCashbackReportCell.h"
#import "QGAlertView.h"
#import "QGGradientView.h"

//Tool
#import "QGCashbackRequestApi.h"
#import "QGCalendarManager.h"
#import "QGApplicationOpenURL.h"
#import "QGUserCenterRequestApi.h"
#import "QGActivityPopManager.h"

//Model
#import "QGCashbackDataSourceModel.h"
#import "QGAppCoreModelClickEvent.h"


@interface QGCashbackViewController ()

/// 返现数据源
@property (nonatomic, strong) QGCashbackDataSourceModel * dataSourceModel;

/// 底部申请视图
@property (nonatomic, strong) UIView * bottomView;

@end

@implementation QGCashbackViewController

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    //登录并且没有数据，才会触发请求
    if ([QGUserInfo sharedUserInfo].isLogin) {
        [self requestData];
    }
    [QGActivityPopManager.shareInstance viewDidAppearAtPosition:QGActivityPositionCashback inController:self];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self initNormalUI];
    
//    [QGActivityPopManager.shareInstance showActivitiesAtPosition:QGActivityPositionCashback inController:self];
}

#pragma mark - 初始化数据
- (void)initNormalUI
{
    [self setNavBarBottomLineHidden:YES];
    [self setupNavBarTitleColor:[UIColor textColor3333] title:@"赚钱"];
    [self setNavBarBackgroundAlpha:0];
    self.tableViewStyle = UITableViewStyleGrouped;
    self.isAboveTabBar = YES;
    self.isBelowNavBar = YES;
    
    @weakify(self);
    QGRefreshNomalHeader * refreshHeader = [self.tableView addHeaderRefreshOnlyWithHandle:^(BOOL isHeaderRefresh) {
        @strongify(self);
        [self requestData];
    }];
    refreshHeader.isExclusionStatusBar = YES;

    //底部推广视图
    [self creatPromoterBottomView];
}

/// 底部推广视图
- (void)creatPromoterBottomView
{
    //底部推广视图
    self.bottomView = [UIView creatViewWithSuperView:self.view backgroundColor:nil];
    self.bottomView.layer.cornerRadius = 6;
    self.bottomView.clipsToBounds = YES;
    self.bottomView.hidden = YES;
    [self.bottomView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.inset(15);
        make.bottom.inset([DeviceAdaptation getTabBarHeight] + 12);
        make.height.mas_equalTo(38);
    }];
    
    //立即申请按钮
    UIButton * applyButton = [UIButton creatButtonWithSuperView:self.bottomView title:@"立即申请" titleFont:[UIFont qg_regularFontOfSize:12] textColor:[UIColor whiteColor]];
    applyButton.backgroundColor = [UIColor colorWithHexString:@"2D2323"];
    [applyButton addTarget:self action:@selector(promoterApplyButtonClick) forControlEvents:UIControlEventTouchUpInside];
    [applyButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.bottom.right.inset(0);
        make.width.mas_equalTo(convertEqualScaleFrom375(100));
    }];
    
    //渐变色
    QGGradientView * gradientView = [[QGGradientView alloc] init];
    gradientView.gradientLayer.colors = [UIColor gradientColorsE9B176ToF2CD8B];
    [self.bottomView addSubview:gradientView];
    [gradientView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.top.bottom.inset(0);
        make.right.mas_equalTo(applyButton.mas_left);
    }];
    
    //小图标
    UIImageView * applyImgView = [UIImageView creatImageViewWithSuperView:gradientView imageName:@"cashback_bottom_apply"];
    [applyImgView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.inset(10);
        make.size.mas_equalTo(CGSizeMake(18, 18));
        make.centerY.offset(0);
    }];
    
    //推广文案
    UILabel * applyLabel = [UILabel creatLabelWithSuperView:gradientView title:@"申请成为推广官  尊享更多赚钱特权" titleFontSize:[UIFont qg_lightFontOfSize:12] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
    [applyLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(applyImgView.mas_right).offset(5);
        make.right.inset(5);
        make.centerY.offset(0);
    }];
    
}


#pragma mark - Request
/// 请求数据
- (void)requestData
{
    NSString * urlString = [QGCashbackRequestApi urlWithIndex:QGCashbackRequestServerMethohHomepage];
//    urlString = @"http://yapi.quantgroups.com/mock/305/vcc/app/returnCash/index";
    //如果已经有数据，则不需要loading了
    BOOL isNeedLoading = self.dataSourceModel ? NO : YES;
    if (isNeedLoading) {
        [QGHUDManager showHud:nil];
    }
    
    [[QGTalosNetwork shareManager] GET:urlString parameters:nil success:^(id  _Nonnull responseObject) {
        if (isNeedLoading) {
            [QGHUDManager hideHud];
        }
        //业务请求成功
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            self.dataSourceModel = [QGCashbackDataSourceModel yy_modelWithDictionary:responseObject[@"data"]];
            [self.tableView reloadData];
            
            //只有普通用户有底部推广视图
            if (self.dataSourceModel.userInfo.promoterLevel.integerValue == 1) {
                self.bottomView.hidden = NO;
            }
            else
            {
                self.bottomView.hidden = YES;
            }
            
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
            [self showRequestFailView];
        }
        [self.tableView endHeaderRefreshWithBlock:nil];
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [self.tableView endHeaderRefreshWithBlock:nil];
        [QGHUDManager hideHud];
        [self showRequestFailView];
    }];
}

/// 网络请求错误弹出视图
- (void)showRequestFailView
{
    @weakify(self);
    [self showErrorPageReloadBlock:^{
        @strongify(self);
        [self requestData];
    }];
}


#pragma mark - UITableViewDataSource

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    //用户信息 | 返现攻略 | 返现收益 | banner | 返现报表 | 月度返现
    return  self.dataSourceModel ? 6 : 0;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    NSInteger numberOfRows = 1;
    switch (section) {
            //返现攻略
        case 1:
            numberOfRows = self.dataSourceModel.returnCashRuleBannerList.count ? 1 : 0;
        break;
            //banner
        case 3:
            numberOfRows = self.dataSourceModel.returnCashActivityBannerList.count ? 1 : 0;
        break;
            //月度返现
        case 5:
            numberOfRows = self.dataSourceModel.returnCashReport.count;
        break;
            
        default:
            break;
    }
    return numberOfRows;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    //用户信息 | 返现攻略 | 返现收益 | banner | 返现报表 | 月度返现
    switch (indexPath.section) {
        //用户信息
        case 0:
        {
            QGCashbackHeaderCell * cell = (QGCashbackHeaderCell *)[self getCellFromClassName:NSStringFromClass([QGCashbackHeaderCell class]) dequeueTableView:tableView];
            cell.userModel = self.dataSourceModel.userInfo;
            //推广按钮点击事件
            [cell.promoterButton addTarget:self action:@selector(headerPromoterButtonClick) forControlEvents:UIControlEventTouchUpInside];
            //头像点击事件
            [cell.avatarButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
                [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGMinePersonalDataViewController) parameters:nil handlerBlock:nil];
            }];
            
            return cell;
        }
            break;
            //返现攻略
        case 1:
        {
            QGCashRuleEntranceCell * cell = (QGCashRuleEntranceCell *)[self getCellFromClassName:NSStringFromClass([QGCashRuleEntranceCell class]) dequeueTableView:tableView];
            cell.returnCashRuleBannerList = self.dataSourceModel.returnCashRuleBannerList;
            
            //快捷入口点击事件
            cell.quickEntryClickBlock = ^(NSInteger index, QGCashbackBannerModel * _Nonnull bannerModel) {
                
                [QGApplicationOpenURL handleAllSupportUrl:bannerModel.jumpUrl];
                
                //神策埋点
                QGAppCoreModelClickEvent * clickEvent = [QGAppCoreModelClickEvent acmcEventWithPage:@"赚钱页" path:@"快捷入口" name:[NSString stringWithFormat:@"QuickEntry_%ld",index + 1] detail_name:bannerModel.name acmc_model_other:bannerModel.jumpUrl];
                [QGAnalyticsService analyticsTrackWithEvent:clickEvent];
            };
            
            return cell;
        }
            break;
        //返现
        case 2:
        {
            QGCashbackIncomeCell * cell = (QGCashbackIncomeCell *)[self getCellFromClassName:NSStringFromClass([QGCashbackIncomeCell class]) dequeueTableView:tableView];
            cell.dataSourceModel = self.dataSourceModel;
            
            
            //累计返现明细
            cell.totalAmountClickBlock = ^{
                [QGApplicationOpenURL handleAllSupportUrl:self.dataSourceModel.returnCashTotalUrl];
            };
            
            //待返现明细
            cell.waitAmountClickBlock = ^{
                [QGApplicationOpenURL handleAllSupportUrl:self.dataSourceModel.waitReturnCashUrl];
            };
            
            //提现
            @weakify(self);
            cell.cashbackClickBlock = ^{
                @strongify(self);
                [self cashbackButtonClick];
            };
            
            return cell;
        }
            break;
            //banner
        case 3:
        {
            QGCashbackBannerCell * cell = (QGCashbackBannerCell *)[self getCellFromClassName:NSStringFromClass([QGCashbackBannerCell class]) dequeueTableView:tableView];
            cell.returnCashActivityBannerList = self.dataSourceModel.returnCashActivityBannerList;
            
            //banner点击事件
            @weakify(self);
            cell.bannerClickBlock = ^(NSInteger index) {
                @strongify(self);
                QGCashbackBannerModel * bannerModel = self.dataSourceModel.returnCashActivityBannerList[index];
                [QGApplicationOpenURL handleAllSupportUrl:bannerModel.jumpUrl];
                
                //神策埋点
                QGAppCoreModelClickEvent * clickEvent = [QGAppCoreModelClickEvent acmcEventWithPage:@"赚钱页" path:@"banner" name:[NSString stringWithFormat:@"Banner_%ld",index + 1] detail_name:bannerModel.name acmc_model_other:bannerModel.jumpUrl];
                [QGAnalyticsService analyticsTrackWithEvent:clickEvent];
            };
            return cell;
        }
            break;
            //返现报表
        case 4:
        {
            QGCashbackBrokenLineCell * cell = (QGCashbackBrokenLineCell *)[self getCellFromClassName:NSStringFromClass([QGCashbackBrokenLineCell class]) dequeueTableView:tableView];
            cell.dataSourceModel = self.dataSourceModel;
            
            //月份选择
            @weakify(self);
            cell.monthSelectBlock = ^(NSNumber * _Nonnull selectMonthSince1970) {
                @strongify(self);
                [self selectMonthSince1970Click:selectMonthSince1970];
            };
            
            //折线图气泡点击事件
            cell.bubbleClickBlock = ^(QGCashbackBrokenLineModel * _Nonnull brokenLineModel) {
                [QGApplicationOpenURL handleAllSupportUrl:brokenLineModel.returnCashUrl];
            };
            
            return cell;
        }
            break;
            //月度返现
        case 5:
        {
            QGCashbackReportCell * cell = (QGCashbackReportCell *)[self getCellFromClassName:NSStringFromClass([QGCashbackReportCell class]) dequeueTableView:tableView];
            [cell setReturnCashReportList:self.dataSourceModel.returnCashReport indexRow:indexPath.row];
            return cell;
        }
            break;
            
        default:
            break;
    }

    return [super tableView:tableView cellForRowAtIndexPath:indexPath];
}

#pragma mark - UITableViewDelegate
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    //月度返现
    if (indexPath.section == 5) {
        QGCashbackCategoryModel * categoryModel = self.dataSourceModel.returnCashReport[indexPath.row];
        [QGApplicationOpenURL handleAllSupportUrl:categoryModel.returnCashUrl];
    }
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CGFloat heightForRow = 0;
    //用户信息 | 返现攻略 | 返现收益 | banner | 返现报表 | 月度返现
    switch (indexPath.section) {
        case 0:
            heightForRow = 116 + [DeviceAdaptation getNavBarAndStatusBarHeight];
            break;
            //返现攻略
        case 1:
            heightForRow = 102;
            break;
        //返现收益
        case 2:
            heightForRow = 338;
            break;
            //banner
        case 3:
            heightForRow = [QGCashbackBannerCell cellHeight];
            break;
            //返现报表
        case 4:
            heightForRow = 233;
            break;
            //月度返现
        case 5:
            heightForRow = 60;
            break;
            
        default:
            break;
    }
        
   
    return heightForRow;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    //月度返现
    if (section == 5 && self.dataSourceModel.returnCashReport.count > 0) {
        return 90;
    }
    return [super tableView:tableView heightForHeaderInSection:section];
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    UIView * view;
    if (section == 5 && self.dataSourceModel.returnCashReport.count > 0) {
        view = [[UIView alloc] initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, 90)];
        
        //标题
        UILabel * titleLabel = [UILabel creatLabelWithSuperView:view title:@"月度返现" titleFontSize:[UIFont qg_mediumFontOfSize:18] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(20);
            make.top.inset(0);
            make.height.mas_equalTo(25);
        }];
        
        //返现数据展示
        UIView * cashbackView = [UIView creatViewWithSuperView:view backgroundColor:[UIColor moduleSeparatorColorF7F7]];
        [cashbackView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(0);
            make.height.mas_equalTo(50);
            make.top.mas_equalTo(titleLabel.mas_bottom).offset(15);
        }];
        
        //返现总笔数
        UILabel * totalTitleLabel = [UILabel creatLabelWithSuperView:cashbackView title:@"总返现" titleFontSize:[UIFont qg_regularFontOfSize:14] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [totalTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(20);
            make.centerY.offset(0);
        }];
        
        //总笔数
        NSString * reportTotalStr = [NSString stringWithFormat:@"共%@笔",self.dataSourceModel.returnCashReportTotal];
        UILabel * reportTotal = [UILabel creatLabelWithSuperView:cashbackView title:reportTotalStr titleFontSize:[UIFont qg_mediumFontOfSize:14] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [reportTotal mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(totalTitleLabel.mas_right).offset(5);
            make.centerY.offset(0);
        }];
        
        //总返现
        NSString * reportTotalAmountStr = [NSString stringWithFormat:@"¥%@",self.dataSourceModel.returnCashReportTotalAmount];
        UILabel * reportTotalAmountLabel = [UILabel creatLabelWithSuperView:cashbackView title:reportTotalAmountStr titleFontSize:[UIFont qg_mediumFontOfSize:18] textColor:[UIColor textColor3333] alignment:NSTextAlignmentRight];
        [reportTotalAmountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(15);
            make.centerY.offset(0);
        }];
        
    }
    return view;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    //月度返现
    if (section == 5 && self.dataSourceModel.returnCashReport.count > 0) {
        return 50;
    }
    return [super tableView:tableView heightForFooterInSection:section];
}

- (UIView *)tableView:(UITableView *)tableView viewForFooterInSection:(NSInteger)section
{
    UIView * view;
    //月度返现
    if (section == 5 && self.dataSourceModel.returnCashReport.count > 0) {
        view = [[UIView alloc] initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, 50)];
        view.backgroundColor = [UIColor whiteColor];
    }
    return view;
}

#pragma mark - UIScrollViewDelegate
- (void)scrollViewDidScroll:(UIScrollView *)scrollView
{
    CGFloat scrollHeight = 44 + [DeviceAdaptation getNavBarAndStatusBarHeight];
    CGFloat offsetY = scrollView.contentOffset.y;
    CGFloat alpha = MAX(MIN(offsetY/scrollHeight, 1), 0);
    [self setNavBarBackgroundAlpha:alpha];
}

#pragma mark - Action
/// 月份选择
- (void)selectMonthSince1970Click:(NSNumber *)since1970Num
{
    NSString * urlString = [QGCashbackRequestApi urlWithIndex:QGCashbackRequestServerMethodReturnCashReport];
//    urlString = @"http://yapi.quantgroups.com/mock/305/vcc/app/returnCash/report";
    [QGHUDManager showHud:nil];
    NSDictionary * infoDic = @{@"month":since1970Num};
    [[QGTalosNetwork shareManager] GET:urlString parameters:infoDic success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        //请求成功
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            QGCashbackDataSourceModel  * cashbackModel = [QGCashbackDataSourceModel yy_modelWithDictionary:responseObject[@"data"]];
            self.dataSourceModel.returnCashList = cashbackModel.returnCashList;
            self.dataSourceModel.returnCashReport = cashbackModel.returnCashReport;
            self.dataSourceModel.returnCashReportTotal = cashbackModel.returnCashReportTotal;
            self.dataSourceModel.returnCashReportTotalAmount = cashbackModel.returnCashReportTotalAmount;
            [self.tableView reloadData];
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
        
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
    }];
}

///提现按钮点击事件
- (void)cashbackButtonClick
{
    NSString * urlString = [QGCashbackRequestApi urlWithIndex:QGCashbackRequestServerMethodWithdraw];
//    urlString = @"http://yapi.quantgroups.com/mock/305/vcc/app/returnCash/withdraw";
    [QGHUDManager showHud:nil];
    [[QGTalosNetwork shareManager] GET:urlString parameters:nil success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        //请求成功
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary * dataDic = responseObject[@"data"];
            NSString * withdrawUrl = dataDic[@"withdrawUrl"];
            NSString * withdrawDesc = dataDic[@"withdrawDesc"];
            NSInteger withdrawStatus = [dataDic[@"withdrawStatus"] integerValue];
            //提现状态，1可提现，0不可提现
            if (withdrawStatus == 0 && withdrawDesc.length > 0) {
                QGAlertView * alertView = [[QGAlertView alloc] initWithTitle:nil message:withdrawDesc cancelButtonTitle:nil sureButtonTitle:@"知道了" clickBlock:nil];
                [alertView showInView:nil];
            }
            //可提现直接跳转链接
            else if (withdrawStatus == 1)
            {
                [QGApplicationOpenURL handleAllSupportUrl:withdrawUrl];
            }
            else
            {
                [QGHUDManager showHud:@"后台数据异常"];
            }
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
    }];
}

/// 消息点击事件
- (void)messageButtonClick
{
    if ([QGUserInfo sharedUserInfo].login) {//去到消息中心
        [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGMessageCenterVC] parameters:nil handlerBlock:nil];
    }else{
        [self showLoginViewController];
    }
}

/// 顶部推广按钮点击事件，跳转推广链接或者会员中心
- (void)headerPromoterButtonClick
{
    /// 用户级别，1普通用户，2推广新人，3推广达人，4推广专家
    //普通用户埋点
    if (self.dataSourceModel.userInfo.promoterLevel.integerValue == 1) {
        //神策埋点
        QGAppCoreModelClickEvent * clickEvent = [QGAppCoreModelClickEvent acmcEventWithPage:@"赚钱页" path:@"用户等级展示区" name:@"限时招募推广官" detail_name:nil acmc_model_other:self.dataSourceModel.userInfo.promoterLevel];
        [QGAnalyticsService analyticsTrackWithEvent:clickEvent];
    }
    //其他用户埋点
    else
    {
        //神策埋点
        QGAppCoreModelClickEvent * clickEvent = [QGAppCoreModelClickEvent acmcEventWithPage:@"赚钱页" path:@"用户等级展示区" name:@"查看权益" detail_name:nil acmc_model_other:self.dataSourceModel.userInfo.promoterLevel];
        [QGAnalyticsService analyticsTrackWithEvent:clickEvent];
    }
    
    [QGApplicationOpenURL handleAllSupportUrl:self.dataSourceModel.userInfo.promoterLevelUrl];
}

/// 跳转推广链接
- (void)promoterApplyButtonClick
{
    //神策埋点
    QGAppCoreModelClickEvent * clickEvent = [QGAppCoreModelClickEvent acmcEventWithPage:@"赚钱页" path:@"申请推广官" name:@"立即申请" detail_name:nil acmc_model_other:nil];
    [QGAnalyticsService analyticsTrackWithEvent:clickEvent];
    
    [self navigationToWeb:self.dataSourceModel.promoterUrl];
}


@end
