//
//  QGCashbackReportCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/16.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGCashbackReportCell.h"
#import "QGBasicUITool.h"
#import "QGGradientProgressView.h"
#import "UIImageView+QGWebCache.h"
@interface QGCashbackReportCell ()

/// 图标
@property (nonatomic, strong) UIImageView * iconImgView;

/// 返现描述
@property (nonatomic, strong) UILabel * descLabel;

/// 百分比
@property (nonatomic, strong) UILabel * percentLabel;

/// 箭头
@property (nonatomic, strong) UIImageView * arrowImgView;

/// 返现金额
@property (nonatomic, strong) UILabel * amountLabel;

/// 进度条
@property (nonatomic, strong) QGGradientProgressView * progressView;

/// 返现数据汇总
@property (nonatomic, strong) NSArray * returnCashReport;

/// 渐变色数组
@property (nonatomic, strong) NSMutableArray * gradientColorsArray;
@end

@implementation QGCashbackReportCell


- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        //图标
        self.iconImgView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:nil];
        [self.iconImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(20);
            make.top.inset(25);
            make.size.mas_equalTo(CGSizeMake(30, 30));
        }];
        
        //描述
        self.descLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_regularFontOfSize:14] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [self.descLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.iconImgView.mas_right).offset(8);
            make.top.inset(25);
            make.height.mas_equalTo(20);
        }];
        
        //百分比
        self.percentLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_regularFontOfSize:12] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        [self.percentLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.descLabel.mas_right).offset(5);
            make.height.mas_equalTo(17);
            make.centerY.mas_equalTo(self.descLabel);
        }];
        
        //图标
        self.arrowImgView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:@"cashback_report_arrow"];
        [self.arrowImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(8, 14));
            make.right.inset(20);
            make.bottom.inset(13);
        }];
        
        //金额
        self.amountLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_mediumFontOfSize:14] textColor:[UIColor textColor3333] alignment:NSTextAlignmentRight];
        [self.amountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.mas_equalTo(self.arrowImgView.mas_left).offset(-11);
            make.centerY.mas_equalTo(self.descLabel);
        }];
        
        //进度条
        self.progressView = [[QGGradientProgressView alloc] init];
        [self.contentView addSubview:self.progressView];
        [self.progressView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.iconImgView.mas_right).offset(8);
            make.right.mas_equalTo(self.arrowImgView.mas_left).offset(-10);
            make.bottom.inset(5);
            make.height.mas_equalTo(8);
        }];
        
        
        //渐变色数组
        self.gradientColorsArray = [NSMutableArray arrayWithCapacity:0];
        [self.gradientColorsArray addObject:@[(id)[UIColor colorWithHexString:@"F0AB0F"].CGColor,(id)[UIColor colorWithHexString:@"F0AB0F"].CGColor]];
        [self.gradientColorsArray addObject:@[(id)[UIColor colorWithHexString:@"EED315"].CGColor,(id)[UIColor colorWithHexString:@"EED315"].CGColor]];
        [self.gradientColorsArray addObject:@[(id)[UIColor colorWithHexString:@"89C040"].CGColor,(id)[UIColor colorWithHexString:@"89C040"].CGColor]];
        [self.gradientColorsArray addObject:@[(id)[UIColor colorWithHexString:@"4AB35C"].CGColor,(id)[UIColor colorWithHexString:@"4AB35C"].CGColor]];
        [self.gradientColorsArray addObject:@[(id)[UIColor colorWithHexString:@"8EB9A3"].CGColor,(id)[UIColor colorWithHexString:@"8EB9A3"].CGColor]];
        [self.gradientColorsArray addObject:@[(id)[UIColor colorWithHexString:@"7DB6CF"].CGColor,(id)[UIColor colorWithHexString:@"7DB6CF"].CGColor]];
        [self.gradientColorsArray addObject:@[(id)[UIColor colorWithHexString:@"3C81A1"].CGColor,(id)[UIColor colorWithHexString:@"3C81A1"].CGColor]];
        [self.gradientColorsArray addObject:@[(id)[UIColor colorWithHexString:@"2B81D4"].CGColor,(id)[UIColor colorWithHexString:@"2B81D4"].CGColor]];
        [self.gradientColorsArray addObject:@[(id)[UIColor colorWithHexString:@"487BE4"].CGColor,(id)[UIColor colorWithHexString:@"487BE4"].CGColor]];
        [self.gradientColorsArray addObject:@[(id)[UIColor colorWithHexString:@"F15454"].CGColor,(id)[UIColor colorWithHexString:@"F15454"].CGColor]];
        [self.gradientColorsArray addObject:@[(id)[UIColor colorWithHexString:@"F17954"].CGColor,(id)[UIColor colorWithHexString:@"F17954"].CGColor]];
        
    }
    return self;
}


#pragma mark - Setter

/// 设置数据模型和索引
/// @param returnCashReport 数据模型
/// @param indexRow 索引值，用于设置颜色
- (void)setReturnCashReportList:(NSArray <QGCashbackCategoryModel *> *)returnCashReport indexRow:(NSInteger)indexRow
{
    //分类模型
    QGCashbackCategoryModel * categoryModel = returnCashReport[indexRow];
    [self.iconImgView setMallImageByNomalPlaceholderWithURLString:categoryModel.returnCashTypeImg];
    self.descLabel.text = categoryModel.returnCashTypeDesc;
    
    //换算出来百分比
    CGFloat returnCashPerc = categoryModel.returnCashPerc.floatValue * 100;
    self.percentLabel.text = [NSString stringWithFormat:@"%.2f%@",returnCashPerc,@"%"];
    self.progressView.progress = categoryModel.returnCashPerc.floatValue;
    self.amountLabel.text = [NSString stringWithFormat:@"¥%@",categoryModel.returnCashAmount];
    
    //设置渐变色
    if (indexRow < self.gradientColorsArray.count) {
        self.progressView.gradientLayer.colors = self.gradientColorsArray[indexRow];
    }
    
    
}



- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
