//
//  QGCashbackHeaderCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/4/27.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGCashbackHeaderCell.h"
#import "QGGradientView.h"
#import "QGBasicUITool.h"
#import "UIImageView+QGWebCache.h"
@interface QGCashbackHeaderCell ()

/// 用户级别标识
@property (nonatomic, strong) UIImageView * levelIconImgView;

/// 用户级别名称图标
@property (nonatomic, strong) UIImageView * levelNameImgView;

/// 用户级别提示
@property (nonatomic, strong) UILabel * levelTipsLabel;

/// 推广按钮
@property (nonatomic, strong, readwrite) QGGradientShadowButton * promoterButton;

/// 头像底层白底+按钮事件
@property (nonatomic, strong, readwrite) UIButton * avatarButton;

/// 头像图片
@property (nonatomic, strong) UIImageView * avatarImgView;

/// 名称
@property (nonatomic, strong) UILabel * nameLabel;

/// 邀请码
@property (nonatomic, strong) UILabel * inviteTitleLabel;

/// 邀请码
@property (nonatomic, strong) UILabel * inviteCodeLabel;

/// 复制粘贴按钮
@property (nonatomic, strong) UIButton * pasteButton;

@end


@implementation QGCashbackHeaderCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
                
        //顶部背景图
        UIImageView * bgImgView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:@"cashback_header_bg"];
        bgImgView.clipsToBounds = YES;
        bgImgView.contentMode = UIViewContentModeScaleAspectFill;
        [bgImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.bottom.inset(0);
        }];
        
        //推广新手渐变黑色底色
        QGGradientView * gradientView = [[QGGradientView alloc] initWithRadius:6 corner:UIRectCornerTopLeft | UIRectCornerTopRight];
        gradientView.clipsToBounds = YES;
        [self.contentView addSubview:gradientView];
        gradientView.gradientLayer.colors = @[(id)[UIColor colorWithHexString:@"6B6156"].CGColor,(id)[UIColor colorWithHexString:@"000000"].CGColor];
        gradientView.gradientLayer.startPoint = CGPointMake(0.5, 0);
        gradientView.gradientLayer.endPoint = CGPointMake(0.5, 1);
        [gradientView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.height.mas_equalTo(54);
            make.bottom.inset(0);
        }];
        
        //左侧底图
        UIImageView * leftBgImgView = [UIImageView creatImageViewWithSuperView:gradientView imageName:@"cashback_header_promoter_bg_left"];
        [leftBgImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.top.bottom.inset(0);
            make.width.mas_equalTo(93);
        }];
        
        //右侧底图
        UIImageView * rightBgImgView = [UIImageView creatImageViewWithSuperView:gradientView imageName:@"cashback_header_promoter_bg_right"];
        [rightBgImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.width.mas_equalTo(179);
            make.top.bottom.right.inset(0);
        }];
        
        
        //用户级别标识
        self.levelIconImgView = [UIImageView creatImageViewWithSuperView:gradientView imageName:nil];
        [self.levelIconImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(10);
            make.size.mas_equalTo(CGSizeMake(40, 40));
            make.centerY.offset(0);
        }];
        
        //用户级别名称
        self.levelNameImgView = [UIImageView creatImageViewWithSuperView:gradientView imageName:nil];
        [self.levelNameImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.levelIconImgView.mas_right).offset(5);
            make.top.inset(12);
            make.size.mas_equalTo(CGSizeMake(56, 14));
        }];
        
        
        //用户级别提示
        self.levelTipsLabel = [UILabel creatLabelWithSuperView:gradientView title:nil titleFontSize:[UIFont qg_lightFontOfSize:12] textColor:[UIColor whiteColor] alignment:NSTextAlignmentCenter];
        [self.levelTipsLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.levelNameImgView);
            make.top.mas_equalTo(self.levelNameImgView.mas_bottom).offset(5);
            make.height.mas_equalTo(16);
        }];
        
        //推广按钮
        self.promoterButton = [QGGradientShadowButton creatGradientColorButtonWithSuperView:gradientView title:nil textFont:[UIFont qg_lightFontOfSize:12]];
        [self.promoterButton setTitleColor:[UIColor textColor3333] forState:UIControlStateNormal];
        self.promoterButton.titleLabel.textAlignment = NSTextAlignmentCenter;
        self.promoterButton.gradientLayer.colors = [UIColor gradientColorsE9B176ToF2CD8B];
        [self.promoterButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(15);
            make.height.mas_equalTo(19);
            make.centerY.offset(0);
            make.width.mas_equalTo(118);
        }];
        
        //头像
        self.avatarButton = [UIButton creatButtonWithSuperView:self.contentView title:nil titleFont:nil textColor:nil];
        self.avatarButton.layer.cornerRadius = 46/2.0;
        self.avatarButton.backgroundColor = [UIColor whiteColor];
        self.avatarButton.clipsToBounds = YES;
        [self.avatarButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(20);
            make.size.mas_equalTo(CGSizeMake(46, 46));
            make.bottom.mas_equalTo(gradientView.mas_top).offset(-15);
        }];
        
        //头像载体
        self.avatarImgView = [UIImageView creatImageViewWithSuperView:self.avatarButton imageName:nil];
        self.avatarImgView.layer.cornerRadius = 22;
        self.avatarImgView.clipsToBounds = YES;
        [self.avatarImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.center.offset(0);
            make.size.mas_equalTo(CGSizeMake(44, 44));
        }];
        
        
        //用户名称
        self.nameLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_mediumFontOfSize:18] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [self.nameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.avatarButton.mas_right).offset(10);
            make.centerY.mas_equalTo(self.avatarButton).offset(-10);
            make.height.mas_equalTo(25);
        }];
        
        //邀请码标题
        self.inviteTitleLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"邀请码：" titleFontSize:[UIFont qg_lightFontOfSize:12] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        [self.inviteTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.nameLabel);
            make.top.mas_equalTo(self.nameLabel.mas_bottom).offset(3);
            make.height.mas_equalTo(17);
        }];
        
        //邀请码
        self.inviteCodeLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_regularFontOfSize:12] textColor:[UIColor textColor6666] alignment:NSTextAlignmentCenter];
        self.inviteCodeLabel.backgroundColor = [UIColor whiteColor];
        [self.inviteCodeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.inviteTitleLabel.mas_right).offset(0);
            make.height.mas_equalTo(19);
            make.width.greaterThanOrEqualTo(@(85));
            make.centerY.mas_equalTo(self.inviteTitleLabel);
        }];
        self.inviteCodeLabel.layer.cornerRadius = 3;
        self.inviteCodeLabel.clipsToBounds = YES;
        
        //复制按钮
        self.pasteButton = [UIButton creatButtonWithSuperView:self.contentView title:@"复制" titleFont:[UIFont qg_regularFontOfSize:10] textColor:[UIColor textColor9999]];
        [self.pasteButton addTarget:self action:@selector(pasteButtonClick) forControlEvents:UIControlEventTouchUpInside];
        [self.pasteButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(31, 16));
            make.left.mas_equalTo(self.inviteCodeLabel.mas_right).offset(10);
            make.centerY.mas_equalTo(self.inviteTitleLabel);
        }];
        [self.pasteButton setBorder:[UIColor textColor9999] width:1];
        self.pasteButton.layer.cornerRadius = 3;
        
        
        
        
    }
    return self;
}


#pragma mark - Setter
- (void)setUserModel:(QGCashbackUserInfoModel *)userModel
{
    if (_userModel != userModel) {
        _userModel = userModel;
        
        [self.avatarImgView setImageWithPlaceholder:@"cashback_header_avatar" URLString:userModel.avatar];
        self.nameLabel.text = [NSString stringWithFormat:@"你好，%@",userModel.phoneNo];
        self.inviteCodeLabel.text = userModel.inviteCode;
        [self.levelIconImgView setMallImageByNomalPlaceholderWithURLString:userModel.promoterLevelImg];
        [self.levelNameImgView setMallImageByNomalPlaceholderWithURLString:userModel.promoterLevelDescImg];
        self.levelTipsLabel.text = userModel.promoterLevelTips;
        
        //用户级别，1普通用户，2推广新人，3推广达人，4推广专家
        if (userModel.promoterLevel.integerValue == 1) {
            [self.promoterButton setTitle:@"限时招募推广官" forState:UIControlStateNormal];
            [self.promoterButton setImage:[UIImage imageNamed:@"cashback_header_promoter"] forState:UIControlStateNormal];
            
            //隐藏邀请码相关
            self.inviteTitleLabel.hidden = YES;
            self.inviteCodeLabel.hidden = YES;
            self.pasteButton.hidden = YES;
            
            //更新位置
            [self.nameLabel mas_updateConstraints:^(MASConstraintMaker *make) {
                make.centerY.mas_equalTo(self.avatarButton).offset(0);
            }];
            
            [self.levelIconImgView mas_updateConstraints:^(MASConstraintMaker *make) {
                make.size.mas_equalTo(CGSizeMake(0, 0));
            }];
        }
        else
        {
            [self.promoterButton setTitle:@"查看会员权益>>" forState:UIControlStateNormal];
            [self.promoterButton setImage:nil forState:UIControlStateNormal];
            
            //显示邀请码相关
            self.inviteTitleLabel.hidden = NO;
            self.inviteCodeLabel.hidden = NO;
            self.pasteButton.hidden = NO;
            
            //更新位置
            [self.nameLabel mas_updateConstraints:^(MASConstraintMaker *make) {
                make.centerY.mas_equalTo(self.avatarButton).offset(-10);
            }];
            
            [self.levelIconImgView mas_updateConstraints:^(MASConstraintMaker *make) {
                make.size.mas_equalTo(CGSizeMake(40, 40));
            }];
        }
        
        
        
        
    }
}

#pragma mark - Action

/// 复制按钮点击
- (void)pasteButtonClick
{
    if (self.userModel.inviteCode) {
        UIPasteboard * paste = [UIPasteboard generalPasteboard];
          paste.string = self.userModel.inviteCode;
          paste.strings = @[self.userModel.inviteCode];
          [QGHUDManager showHud:@"复制成功"];
    }
}


@end
