//
//  QGBrokenLineMonthModel.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/13.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGBrokenLineMonthModel.h"
#import "ZHAttributedLabelTool.h"
#import "UIFont+QGFont.h"
#import "UIColor+QGColor.h"
@implementation QGBrokenLineMonthModel

@end

@implementation QGBrokenLineDayModel


- (NSString *)monthAndDay
{
    if (_monthAndDay.length == 0 && self.month.length > 0 && self.day.length > 0) {
        _monthAndDay = [NSString stringWithFormat:@"%@-%@",self.month,self.day];
    }
    return _monthAndDay;
}

- (NSAttributedString *)bubbleTitleStr
{
    if (!_bubbleTitleStr) {
        
        NSString * returnCashAmount = self.brokenLineModel.returnCashAmount ? self.brokenLineModel.returnCashAmount : @"0.00";
        NSString * titleStr = [NSString stringWithFormat:@"收入¥%@",returnCashAmount];
        if (self.brokenLineModel.returnCashAmount.floatValue > 0) {
            titleStr = [titleStr stringByAppendingString:@" "];
        }
        
        //气泡弹窗文案
        ZHAttributedLabelTool * bubbleTool = [[ZHAttributedLabelTool alloc] initWithText:titleStr font:[UIFont qg_mediumFontOfSize:13] color:[UIColor whiteColor]];
        //有金额才会有跳转按钮
        if (self.brokenLineModel.returnCashAmount.floatValue > 0) {
            [bubbleTool addAttachmentWithImageName:@"cashback_bubble_arrow" index:titleStr.length size:CGRectMake(0, 1, 4, 8)];
        }
        _bubbleTitleStr = [bubbleTool getResultString];
        
        
    }
    return _bubbleTitleStr;
}

//cashback_bubble_arrow
@end
