//
//  QGMembershipTaskCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/4/28.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMembershipTaskCell.h"
#import "QGGradientProgressView.h"
#import "QGGradientShadowButton.h"
#import "QGBasicUITool.h"
#import "QGAlertView.h"
@interface QGMembershipTaskCell ()

/// 标题
@property (nonatomic, strong) UILabel * titleLabel;

/// 进度条
@property (nonatomic, strong) QGGradientProgressView * progressView;

/// 详情
@property (nonatomic, strong) UILabel * descLabel;

/// 任务按钮
@property (nonatomic, strong, readwrite) QGGradientShadowButton * taskButton;

/// 提示按钮
@property (nonatomic, strong) UIButton * tipsButton;

@end

@implementation QGMembershipTaskCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        self.backgroundColor = [UIColor clearColor];
        
        //标题
        self.titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_mediumFontOfSize:12] textColor:[UIColor whiteColor] alignment:NSTextAlignmentLeft];
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(20);
            make.top.inset(3);
            make.height.mas_equalTo(17);
        }];
        
        //进度条
        self.progressView = [[QGGradientProgressView alloc] init];
        self.progressView.gradientLayer.colors = [UIColor gradientColorsE9B176ToF2CD8B];
        [self.contentView addSubview:self.progressView];
        
        [self.progressView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.mas_equalTo(self.titleLabel.mas_bottom).offset(6);
            make.left.mas_equalTo(self.titleLabel);
            make.height.mas_equalTo(9);
            make.right.inset(145);
        }];
        
        //描述
        self.descLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_lightFontOfSize:12] textColor:[[UIColor whiteColor] colorWithAlphaComponent:0.7] alignment:NSTextAlignmentLeft];
        [self.descLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.titleLabel);
            make.top.mas_equalTo(self.progressView.mas_bottom).offset(5);
        }];
        
        
        //按钮
        self.taskButton = [QGGradientShadowButton creatGradientColorButtonWithSuperView:self.contentView title:nil textFont:[UIFont qg_lightFontOfSize:12]];
        self.taskButton.gradientLayer.colors = [UIColor gradientColorsE9B176ToF2CD8B];
        [self.taskButton setTitleColor:[UIColor textColor3333] forState:UIControlStateNormal];
        [self.taskButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(20);
            make.centerY.offset(0);
            make.height.mas_equalTo(19);
            make.width.greaterThanOrEqualTo(@(74));
        }];
        
        
        //提示按钮
        self.tipsButton = [UIButton creatButtonWithSuperView:self.contentView title:nil titleFont:nil textColor:nil];
        [self.tipsButton setImage:[UIImage imageNamed:@"membership_task_tips"] forState:UIControlStateNormal];
        [self.tipsButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(50, 17));
            make.centerY.mas_equalTo(self.descLabel);
            make.left.mas_equalTo(self.descLabel.mas_right).offset(-16);
        }];
        [self.tipsButton addTarget:self action:@selector(tipsButtonClick) forControlEvents:UIControlEventTouchUpInside];
    }
    return self;
}


- (void)setSubTaskModel:(QGMembershipSubTaskModel *)subTaskModel
{
    if (_subTaskModel != subTaskModel) {
        _subTaskModel = subTaskModel;
        
        self.titleLabel.text = subTaskModel.taskTitle;
        self.descLabel.text = subTaskModel.taskDesc;
        self.progressView.progress = subTaskModel.taskPercent.floatValue;
        [self.taskButton setTitle:subTaskModel.jumpDesc forState:UIControlStateNormal];
        
        self.tipsButton.hidden = [NSString isEmpty:subTaskModel.taskTips];
    }
}


#pragma mark - Action

/// 提示按钮点击事件
- (void)tipsButtonClick
{
    QGAlertView * alertView = [[QGAlertView alloc] initWithTitle:nil message:self.subTaskModel.taskTips cancelButtonTitle:nil sureButtonTitle:@"知道了" clickBlock:nil];
    alertView.alertStyle = QGAlertStyleBlack;
    [alertView showInView:nil];
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
