//
//  QGMembershipNotificationCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/4/28.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMembershipNotificationCell.h"
#import "QGMarqueeView.h"
#import "QGBasicUITool.h"
#import "QGGradientView.h"
@interface QGMembershipNotificationCell ()

/// 公告
@property (nonatomic, strong) QGMarqueeView * notificationView;

@end

@implementation QGMembershipNotificationCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        self.backgroundColor = [UIColor clearColor];
        
        QGGradientView * gradientView = [[QGGradientView alloc] init];
        gradientView.gradientLayer.colors = [UIColor gradientColorsE9B176ToF2CD8B:0.4];
        [self.contentView addSubview:gradientView];
        gradientView.layer.cornerRadius = 25/2.0;
        gradientView.clipsToBounds = YES;
        
        [gradientView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerY.mas_offset(0);
            make.left.right.inset(20);
            make.height.mas_equalTo(25);
        }];
        
        
        //消息通知
        self.notificationView = [[QGMarqueeView alloc] init];
        self.notificationView.textColor = [UIColor whiteColor];
        self.notificationView.hiddenIndicator = YES;
        [gradientView addSubview:self.notificationView];
        [self.notificationView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.bottom.inset(0);
            make.left.right.inset(15);
        }];

        @weakify(self);
        self.notificationView.clickEventBlock = ^(NSInteger index) {
            @strongify(self);
            if (self.clickBlock) {
                self.clickBlock(index);
            }
        };
    }
    return self;
}

- (void)setNotificationArray:(NSArray<QGNotifyInfoModel *> *)notificationArray
{
    if (_notificationArray != notificationArray) {
        _notificationArray = notificationArray;
        
        //通知
        NSMutableArray * titleArray = [NSMutableArray arrayWithCapacity:0];
        for (QGNotifyInfoModel * infoModel in _notificationArray) {
            [titleArray addObject:infoModel.title];
        }
        self.notificationView.textArray = titleArray;
        
    }
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
