//
//  QGSharePosterViewController.m
//  VirtualPayment
//
//  Created by silicn on 2020/4/27.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGSharePosterViewController.h"
#import "QGGradientShadowButton.h"

#import "QGSharePosterModel.h"
#import "QGBusinessRequestApi.h"

#import "QGSharePosterCollectionViewCell.h"
#import "QGCustomPageControl.h"


#import "SDWebImageDownloader.h"
#import "SDWebImageDownloaderOperation.h"
#import "SDImageCache.h"
#import "SDWebImageManager.h"

#import <Photos/Photos.h>
#import "QGAlertView.h"
#import "QGCacheManager.h"
#import "QGShareView.h"

#ifndef dispatch_main_async_safe
#define dispatch_main_async_safe(block)\
    if (dispatch_queue_get_label(DISPATCH_CURRENT_QUEUE_LABEL) == dispatch_queue_get_label(dispatch_get_main_queue())) {\
        block();\
    } else {\
        dispatch_async(dispatch_get_main_queue(), block);\
    }
#endif

@interface QGSharePosterViewController ()<UICollectionViewDelegate,UICollectionViewDataSource>
///奖励规则
@property (nonatomic, copy) NSString *rewardUrl ;
///分享描述
@property (nonatomic, copy) NSString *shareDesc ;
/// 海报总数
@property (nonatomic, strong) NSMutableArray *posetrs;
/// 图片url集合
@property (nonatomic, strong) NSMutableArray *imagesArray;
/// 二维码图像,如果网络下载失败,则使用默认的图片
@property (nonatomic, strong) UIImage *qrImage ;
/// 分享按钮
@property (nonatomic, strong) QGGradientShadowButton *shareBtn ;

@property (nonatomic, strong) UICollectionView *collectionView ;

@property (nonatomic, strong) QGCustomPageControl *pageControl;
///当前海报位置
@property (nonatomic, assign) NSInteger currentPageIndex;


@end

@implementation QGSharePosterViewController

- (BOOL)checkParameters:(NSDictionary *)param
{
    return YES;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self initNavgation];
    
    [self initNomallUI];
    
    [self requestData];
   
    
}

- (void)initNavgation
{
    self.title = @"分享好友";
    [self custemLeftDefaultBarButtonItem];
    @weakify(self);
    [self custemRightBarButtonItemWithTitle:@"奖励规则" imageName:nil action:^(UIButton * _Nonnull button) {
        @strongify(self);
        [self toReward];
    }];
}

- (void)initNomallUI
{
    /// 底部视图
    UIView *bottomView = [[UIView alloc]initWithFrame:CGRectZero];
    [self.view addSubview:bottomView];
    
    [bottomView mas_makeConstraints:^(MASConstraintMaker *make) {
        if (@available(iOS 11.0, *)) {
            make.bottom.equalTo(self.view.mas_safeAreaLayoutGuideBottom);
        } else {
            make.bottom.equalTo(self.view.mas_bottom);
        }
        make.height.mas_equalTo(70);
        make.left.right.equalTo(self.view);
    }];
    
    UIView *bottomLine = [[UIView alloc]init];
    [bottomView addSubview:bottomLine];
    bottomLine.backgroundColor = UIColor.lineSeparatorColorDCDC;
    [bottomLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.equalTo(bottomView);
        make.height.mas_equalTo(0.5);
    }];
    /// 保存图片
    UIButton *saveBtn = [UIButton creatButtonWithSuperView:bottomView title:@"保存图片" titleFont:[UIFont qg_regularFontOfSize:16.0f] textColor:UIColor.yyMainThemeColor];
    [saveBtn setImage:[UIImage imageNamed:@"share_save"] forState:UIControlStateNormal];
    saveBtn.titleLabel.adjustsFontSizeToFitWidth = YES;
    [saveBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.inset(20);
        make.width.mas_greaterThanOrEqualTo(60);
        make.centerY.equalTo(bottomView);
    }];
    
    [saveBtn addTarget:self action:@selector(saveImage) forControlEvents:UIControlEventTouchUpInside];
    
    ///底部右边背景视图
    UIView *rightView = [UIView creatViewWithSuperView:bottomView backgroundColor:UIColor.whiteColor];
    [rightView setBorder:UIColor.yyMainThemeColor width:1.0f];
    [rightView setRadius:20.0f];
    [rightView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(saveBtn.mas_right).offset(20);
        make.right.inset(20);
        make.centerY.equalTo(rightView);
        make.width.equalTo(saveBtn.mas_width).multipliedBy(3.0f);
        make.top.inset(15.0f);
    }];
    ///邀请链接
    UIButton *inviteBtn = [UIButton creatButtonWithSuperView:rightView title:@"复制链接" titleFont:[UIFont qg_regularFontOfSize:16.0f] textColor:UIColor.yyMainThemeColor];
    [inviteBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.inset(0);
        make.height.mas_equalTo(40);
        make.top.bottom.equalTo(rightView);
    }];
    
    [inviteBtn addTarget:self action:@selector(inviteAction) forControlEvents:UIControlEventTouchUpInside];
    
    ///分享海报
    QGGradientShadowButton *shareBtn = [QGGradientShadowButton creatGradientColorButtonWithSuperView:rightView title:@"分享海报" textFont:[UIFont qg_regularFontOfSize:16.0f]];
    shareBtn.isClearCorner = YES;
    [shareBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.equalTo(rightView);
        make.height.width.equalTo(inviteBtn);
        make.centerY.equalTo(inviteBtn);
        make.left.equalTo(inviteBtn.mas_right);
    }];
    self.shareBtn = shareBtn;
    
    [shareBtn addTarget:self action:@selector(toShare) forControlEvents:UIControlEventTouchUpInside];
    
    /// content 海报
    CGFloat  height = MAINSCREEN_HEIGHT *0.68;
    
    UICollectionViewFlowLayout *layout = [[UICollectionViewFlowLayout alloc]init];
    layout.scrollDirection = UICollectionViewScrollDirectionHorizontal;
    layout.itemSize = CGSizeMake(MAINSCREEN_WIDTH, height);
    layout.minimumInteritemSpacing = 0.0f;
    layout.minimumLineSpacing = 0.0f;
    
    self.collectionView = [[UICollectionView alloc]initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, MAINSCREEN_HEIGHT) collectionViewLayout:layout];
    _collectionView.backgroundColor = UIColor.whiteColor;
    
    _collectionView.delegate = self;
    _collectionView.dataSource = self;
    _collectionView.pagingEnabled = YES;
    _collectionView.showsVerticalScrollIndicator = NO;
    _collectionView.showsHorizontalScrollIndicator = NO;
    [self.view addSubview:self.collectionView];
    
    [self.collectionView registerClass:[QGSharePosterCollectionViewCell class] forCellWithReuseIdentifier:@"QGSharePosterCollectionViewCell"];
    
    [self.collectionView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.height.equalTo(@([UIScreen mainScreen].bounds.size.height * 0.68));
        make.width.equalTo(@(MAINSCREEN_WIDTH));
        make.centerX.equalTo(self.view);
        make.centerY.equalTo(self.view);
    }];
    
    self.pageControl = [[QGCustomPageControl alloc]init];
    self.pageControl.userInteractionEnabled = NO;
    self.pageControl.indictorSize = CGSizeMake(6, 6);
    self.pageControl.indictorSpace = 5;
    self.pageControl.pageIndicatorTintColor = [UIColor colorWithHexString:@"#acacac"];
    self.pageControl.currentPageIndicatorTintColor = [UIColor yyMainThemeColor];
    self.pageControl.hidesForSinglePage = YES;
    [self.view addSubview:_pageControl];
    
    [self.pageControl mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.collectionView.mas_bottom).offset(10);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(10);
    }];
    
    self.currentPageIndex = 0;
   
}

#pragma mark - Collection DataSource & Delegate

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return self.posetrs.count;
}

// The cell that is returned must be retrieved from a call to -dequeueReusableCellWithReuseIdentifier:forIndexPath:
- (__kindof UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    QGSharePosterCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"QGSharePosterCollectionViewCell" forIndexPath:indexPath];
    QGSharePosterModel *poster  = self.posetrs[indexPath.row];
    cell.poster = poster;
    return cell;
}

- (void)scrollViewWillEndDragging:(UIScrollView *)scrollView withVelocity:(CGPoint)velocity targetContentOffset:(inout CGPoint *)targetContentOffset
{
    self.currentPageIndex = (*targetContentOffset).x/CGRectGetWidth(scrollView.frame);
    self.pageControl.currentPage = self.currentPageIndex;
}

#pragma mark - Request

- (void)requestData
{
    self.posetrs = [NSMutableArray arrayWithCapacity:1];
    [QGHUDManager showHud:nil];
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
    [networking GET:[QGBusinessRequestApi urlWithIndex:QGBusinessRequestServerMethodSharePoster] parameters:nil success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary *data = responseObject[@"data"];
            self.rewardUrl = data[@"rewardUrl"];
            self.shareDesc = data[@"shareDesc"];
            NSArray *list = data[@"shareBannerList"];
            for (NSDictionary *dic in list) {
                QGSharePosterModel *model = [QGSharePosterModel yy_modelWithJSON:dic];
                [self.posetrs addObject:model];
            }
            self.pageControl.numberOfPages = self.posetrs.count;
            self.pageControl.currentPage = 0;
            [self.collectionView reloadData];
            /// 下载二维码
            [self downLoadQrImage];
          

        }else{
            [QGHUDManager showHud:responseObject[@"msg"] ?responseObject[@"msg"] :@"获取错误"];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager hideHud];
        @weakify(self);
        QGDefaultView * view = [QGDefaultView defaultViewShowWithSuperView:self.view reloadBlock:^{
            @strongify(self);
            //开始下拉刷新
            [self requestData];
        }];
        view.viewType = QGDefaultViewTypeBadNetwork;
    }];
}


#pragma mark - 自定义事件

/// 奖励规则
- (void)toReward
{
    [self navigationToWeb:self.rewardUrl];
}

/// 邀请链接
- (void)inviteAction
{
    if (self.shareDesc) {
        UIPasteboard *pasteboard = [UIPasteboard generalPasteboard];
        pasteboard.string = self.shareDesc;
        pasteboard.strings = @[self.shareDesc];
        [QGHUDManager showHud:@"复制成功"];
    }
    
    QGAppCoreModelClickEvent *event = [QGAppCoreModelClickEvent acmcEventWithPage:@"分享好友" path:@"分享操作" name:@"复制链接" detail_name:nil];
    [QGAnalyticsService analyticsTrackWithEvent:event];
    
}

///分享
- (void)toShare
{
    
    QGAppCoreModelClickEvent *event = [QGAppCoreModelClickEvent acmcEventWithPage:@"分享好友" path:@"分享操作" name:@"分享海报" detail_name:nil];
    [QGAnalyticsService analyticsTrackWithEvent:event];
    
    if (self.currentPageIndex >= self.posetrs.count) return;
    
    QGSharePosterModel *poster = self.posetrs[self.currentPageIndex];
    SDImageCache *cache = [SDImageCache sharedImageCache];
    
    UIImage *image = [cache imageFromCacheForKey:poster.img];

    if (!image || !self.qrImage) {
        [QGHUDManager showHud:@"图片正在加载..."];
        return;
    }
    
    [self drawImage:image inviteCode:poster.inviteCode complete:^(UIImage *resultImage) {
         [self showShareViewWithImage:resultImage];
    }];
}

- (void)showShareViewWithImage:(UIImage *)image
{
       QGShareModel *model = [[QGShareModel alloc]init];
       model.shareObjType = QGShareModelObjTypeImage;
       model.image = image;
       QGShareView *shareView = [[QGShareView alloc]initWithItems:nil shareModel:model];
       [shareView showInView:self.view];
       
       @weakify(self);
       //自己处理分享事件
       shareView.takeOverShareBlock = ^(QGShareItemType shareItemType) {
           @strongify(self);
           [self shareWithItemType:shareItemType shareModel:model];
           
           //模块名称
           NSString * modelName = nil;
           switch (shareItemType) {
               case QGShareItemTypeQQ:
                   modelName = @"QQ好友";
                   break;
               case QGShareItemTypeQQZone:
                   modelName = @"QQ空间";
               break;
               case QGShareItemTypeTimeLine:
                   modelName = @"朋友圈";
               break;
               case QGShareItemTypeWeChat:
                   modelName = @"微信";
               break;
                   
               default:
                   break;
           }
           QGAppCoreModelClickEvent *event = [QGAppCoreModelClickEvent acmcEventWithPage:@"分享好友" path:@"分享控件" name:modelName detail_name:nil];
           [QGAnalyticsService analyticsTrackWithEvent:event];
       };
}

/// 分发到各个平台
/// @param itemType 分享平台
/// @param shareModel 分享数据
- (void)shareWithItemType:(QGShareItemType)itemType shareModel:(QGShareModel *)shareModel
{
    [self showPaste];
    
    //平台分享
    NSDictionary * shareDic = [shareModel convertToShareDic];
    //触发分享
    [[QGThirdPlatformService shareInstance] shareImageWithType:itemType dictionary:shareDic resultBlock:NULL];
    
}

- (void)showPaste
{
    if (self.shareDesc) {
        UIPasteboard *pasteboard = [UIPasteboard generalPasteboard];
        pasteboard.string = self.shareDesc;
        pasteboard.strings = @[self.shareDesc];
        [QGHUDManager showHud:@"已复制文案到剪贴板"];
    }
}


/// 保存图片
- (void)saveImage
{
  
    QGAppCoreModelClickEvent *event = [QGAppCoreModelClickEvent acmcEventWithPage:@"分享好友" path:@"分享操作" name:@"保存图片" detail_name:nil];
    [QGAnalyticsService analyticsTrackWithEvent:event];
    
    if (self.currentPageIndex >= self.posetrs.count) return;
    
    QGSharePosterModel *poster = self.posetrs[self.currentPageIndex];
    
    SDImageCache *cache = [SDImageCache sharedImageCache];
    UIImage *image = [cache imageFromCacheForKey:poster.img];

    if (!image || !self.qrImage) {
           [QGHUDManager showHud:@"图片正在加载..."];
           return;
    }
    
    [self drawImage:image inviteCode:poster.inviteCode complete:^(UIImage *resultImage) {
        PHAuthorizationStatus photoAuthorStatus = [PHPhotoLibrary authorizationStatus];

           if (photoAuthorStatus == PHAuthorizationStatusNotDetermined) {
               [PHPhotoLibrary requestAuthorization:^(PHAuthorizationStatus status) {
                   if (status == PHAuthorizationStatusAuthorized) {
                       [self saveToLibrary:resultImage complete:NULL];
                   }
               }];
           }else if (photoAuthorStatus == PHAuthorizationStatusAuthorized){
               [self saveToLibrary:resultImage complete:NULL];
           }else{
               QGAlertView * alert = [[QGAlertView alloc] initWithTitle:@"保存失败" message:@"您未开启照片权限，请前往设置-隐私-照片中打开访问照片权限" cancelButtonTitle:@"我知道了" sureButtonTitle:@"去开启" clickBlock:^(NSInteger index) {
                   if (index == 1) {
                       [self jumpSetting];
                   }
               }];
               [alert showInView:nil];
           }
    }];
    
}

///跳转设置中心
- (void)jumpSetting
{
    NSURL *url = [NSURL URLWithString:UIApplicationOpenSettingsURLString];
    if([[UIApplication sharedApplication]canOpenURL:url]) {
        if (@available(iOS 10.0, *)) {
            [[UIApplication sharedApplication] openURL:url options:@{} completionHandler:nil];
        } else {
            [[UIApplication sharedApplication] openURL:url];
            // Fallback on earlier versions
        }
    }
}

//写入图片到相册
- (void)saveToLibrary:(UIImage *)image complete:(void(^)(void))complete
{
    [[PHPhotoLibrary sharedPhotoLibrary] performChanges:^{
         [PHAssetChangeRequest creationRequestForAssetFromImage:image];
     } completionHandler:^(BOOL success, NSError * _Nullable error) {
         //保存成功后，弹窗并跳转到朋友圈
         if (success) {
             //更新到主线程
             dispatch_main_async_safe(^{
                 if (complete) {
                     complete();
                 }
                 [QGHUDManager showHud:@"图片已保存至手机相册"];
             });
         }
    }];
}

#pragma mark - 下载合成图片



/// 下载二维码,如果二维码下载下来,则展示
/// 二维码下载失败,整个页面不展示
- (void)downLoadQrImage
{
    if (self.posetrs.count == 0) return;
    
    SDWebImageManager *manager = [SDWebImageManager sharedManager];
    QGSharePosterModel *firstPoster = [self.posetrs firstObject];
    /// 下载最新二维码,二维码下载不下来,直接使用默认的二维码
    [manager loadImageWithURL:[NSURL URLWithString:firstPoster.qrImgUrl] options:SDWebImageLowPriority progress:NULL completed:^(UIImage * _Nullable image, NSData * _Nullable data, NSError * _Nullable error, SDImageCacheType cacheType, BOOL finished, NSURL * _Nullable imageURL) {
           if (error == nil) {
               self.qrImage = image;
           }
    }];

}

/// 图片合成  原始图片-二维码-邀请码
/// @param image 原始图片
/// @param completeBlock 完成回调
- (void)drawImage:(UIImage *)image inviteCode:(NSString *)inviteCode complete:(void(^)(UIImage *resultImage))completeBlock
{
    @autoreleasepool {
    dispatch_async(dispatch_get_global_queue(0, 0), ^{
        
        /// 注意此处上传的都必须要求是3倍图
        CGFloat scale = 3;
        /// 二维码尺寸
        CGFloat qr_width = 103/312.0 *MAINSCREEN_WIDTH;
        CGFloat qr_height = qr_width;
        /// 图片缩放高度
        CGFloat adjustScaleHeight = image.size.height/(image.size.width/MAINSCREEN_WIDTH);

        UIGraphicsBeginImageContextWithOptions(CGSizeMake(MAINSCREEN_WIDTH, adjustScaleHeight), YES, scale);
        /// 背景图铺满
        [image drawInRect:CGRectMake(0, 0, MAINSCREEN_WIDTH, adjustScaleHeight)];
        /// 二维码底部的距离
        CGFloat qr_bottom_margin =  90/553.0 *adjustScaleHeight;
        CGFloat qr_Y = adjustScaleHeight - qr_height - qr_bottom_margin;
        /// 二维码位置
        [self.qrImage drawInRect:CGRectMake((MAINSCREEN_WIDTH - qr_width)/2, qr_Y, qr_width, qr_height)];
        
        NSMutableParagraphStyle *textStyle = [[NSMutableParagraphStyle defaultParagraphStyle] mutableCopy];
        textStyle.lineBreakMode = NSLineBreakByWordWrapping;
        textStyle.alignment = NSTextAlignmentCenter;
        
        CGRect nameRect = CGRectMake((MAINSCREEN_WIDTH - 80)/2, qr_Y + qr_height + 10, 80, 30);
        [@"邀请码" drawInRect:nameRect withAttributes:@{NSFontAttributeName:[UIFont qg_regularFontOfSize:22.0f],NSForegroundColorAttributeName:UIColor.textColor3333,NSParagraphStyleAttributeName:textStyle}];
        
        /// 获取当前context
        CGContextRef ctx = UIGraphicsGetCurrentContext();
        /// 抗锯齿
        CGContextSetShouldAntialias(ctx, NO);
        CGContextSetStrokeColorWithColor(ctx, UIColor.textColor3333.CGColor);
        CGContextSetLineWidth(ctx, 0.5);
        /// 线长度为50
        CGContextMoveToPoint(ctx, (MAINSCREEN_WIDTH - qr_width)/2 - 20  , qr_Y + qr_height + 25);
        CGContextAddLineToPoint(ctx, (MAINSCREEN_WIDTH - 90)/2, qr_Y + qr_height + 25);
        
        CGContextMoveToPoint(ctx, (MAINSCREEN_WIDTH + 90)/2 ,  qr_Y + qr_height + 25 );
        CGContextAddLineToPoint(ctx, (MAINSCREEN_WIDTH + qr_width)/2  + 20, qr_Y + qr_height + 25);
        CGContextStrokePath(ctx);
        
        /// 绘制白色背景
        CGRect rect = CGRectMake((MAINSCREEN_WIDTH - 128)/2, qr_Y + qr_height + 50, 128, 30);
        UIBezierPath *path = [UIBezierPath bezierPathWithRoundedRect:rect cornerRadius:3];
        CGContextAddPath(ctx, path.CGPath);
        CGContextSetFillColorWithColor(ctx, [UIColor colorWithWhite:1.0 alpha:0.8].CGColor);
        CGContextFillPath(ctx);
        /// 绘制文字
        if (inviteCode != nil && ![inviteCode isEqualToString:@""]) {
            CGRect codeRect = CGRectMake((MAINSCREEN_WIDTH - 128)/2, qr_Y + qr_height + 50, 128, 30);
            [inviteCode  drawInRect:codeRect withAttributes:@{NSFontAttributeName:[UIFont qg_regularFontOfSize:22.0f],NSForegroundColorAttributeName:UIColor.textColor3333,NSParagraphStyleAttributeName:textStyle}];
        }
        
        UIImage *result = UIGraphicsGetImageFromCurrentImageContext();
        UIGraphicsEndImageContext();
        
        dispatch_main_async_safe(^{
            if (completeBlock) {
                completeBlock(result);
            }
        });
       
    });
    }
        
}


- (void)dealloc
{
    NSLog(@"海报  Dealloc");
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
