//
//  QGFansEmptyView.m
//  VirtualPayment
//
//  Created by silicn on 2020/4/29.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGFansEmptyView.h"

#import "QGBasicUITool.h"
#import "QGGradientShadowButton.h"


@interface QGFansEmptyView ()

@property (nonatomic, strong) UIImageView *imageView;

@property (nonatomic, strong) QGGradientShadowButton *commitBtn ;

@end

@implementation QGFansEmptyView

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.imageView = [UIImageView creatImageViewWithSuperView:self imageName:@"no_fans"];
        self.imageView.contentMode = UIViewContentModeScaleAspectFit;
        [self.imageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.inset(30);
            make.left.right.inset(20);
            make.height.mas_equalTo(170);
        }];
        
        self.commitBtn = [QGGradientShadowButton creatGradientColorButtonWithSuperView:self title:@"立即邀请" textFont:[UIFont qg_regularFontOfSize:17.0f]];
        [self.commitBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(self.imageView.mas_bottom).offset(20);
            make.left.right.inset(20);
            make.height.mas_equalTo(40);
            make.bottom.inset(20);
        }];
        
        [self.commitBtn addTarget:self action:@selector(commitAction) forControlEvents:UIControlEventTouchUpInside];
        
    }
    return self;
}

- (void)commitAction
{
    if (self.touchBlock) {
        self.touchBlock();
    }
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
