//
//  QGFansContainerViewController.m
//  VirtualPayment
//
//  Created by silicn on 2020/4/27.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGFansContainerViewController.h"
#import "QGBusinessFansViewController.h"


@interface QGFansContainerViewController ()

@end

@implementation QGFansContainerViewController

- (BOOL)checkParameters:(NSDictionary *)param
{
    return YES;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self initNormalUI];
    
    [self initData];
    // Do any additional setup after loading the view.
}

- (void)initNormalUI
{
    self.title = @"我的粉丝";
    [self custemLeftDefaultBarButtonItem];
//    [self setNavBarBottomLineHidden:YES];
    
}

- (void)initData
{
    self.titles = @[@"全部",@"直属粉丝",@"间接粉丝",@"普通粉丝"];
    CGFloat width = MAINSCREEN_WIDTH /4;
    self.menuItemWidth = width;
    self.itemMargin = 0.0f;
    
    self.menuViewStyle = WMMenuViewStyleLine;
    self.menuBGColor = [UIColor whiteColor];
    self.menuViewLayoutMode = WMMenuViewLayoutModeCenter;
    //进度条
    self.progressViewBottomSpace = 3;
    self.progressWidth = 27;
    self.progressHeight = 2;
    
    //字体
    self.titleFontName = [UIFont qg_regularFontOfSize:15.0].fontName;
    self.titleSizeNormal = 15.0f;
    self.titleSizeSelected = 15.0f;
    self.titleColorNormal = [UIColor textColor3333];
    self.titleColorSelected = [UIColor yyMainThemeColor];
    
    [self reloadData];
}


#pragma mark - WMPageControllerDataSource
- (CGRect)pageController:(WMPageController *)pageController preferredFrameForContentView:(WMScrollView *)contentView
{
    //导航+菜单
    CGFloat Y = [DeviceAdaptation getNavBarAndStatusBarHeight] + 40;
    //移除tabbar的高度
    CGFloat height = MAINSCREEN_HEIGHT - Y;
    return CGRectMake(0, Y, MAINSCREEN_WIDTH, height);
}

/**
 Implement this datasource method, in order to customize your own menuView's frame
 
 @param pageController The container controller
 @param menuView The menuView
 @return The frame of the menuView
 */
- (CGRect)pageController:(WMPageController *)pageController preferredFrameForMenuView:(WMMenuView *)menuView
{
    //导航+菜单
    CGFloat Y = [DeviceAdaptation getNavBarAndStatusBarHeight];
    return CGRectMake(0, Y, MAINSCREEN_WIDTH, 40);
}

- (NSInteger)numbersOfChildControllersInPageController:(WMPageController *)pageController {
    return self.titles.count;
}

- (UIViewController *)pageController:(WMPageController *)pageController viewControllerAtIndex:(NSInteger)index {
    QGBusinessFansViewController *fansVC = [[QGBusinessFansViewController alloc]init];
    fansVC.type = index;
    return fansVC;
}



/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
