//
//  QGDatePickerView.h
//  VirtualPayment
//
//  Created by 张博 on 2020/3/12.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGBasePopView.h"

typedef void(^QGDatePickerViewDoneBlock)(NSInteger yearIndex, NSInteger monthIndex);

NS_ASSUME_NONNULL_BEGIN

@interface QGDatePickerView : QGBasePopView


/// 完成时间
@property (nonatomic, copy) QGDatePickerViewDoneBlock doneBlock;


/// 初始化日期选择器 只支持年月
/// @param yearsArray 年数组
/// @param monthDic 年对应的月数组
- (instancetype)initWithYearsArray:(NSArray *)yearsArray monthDic:(NSDictionary *)monthDic;

/// 外部反选内部位置
/// @param firstIndex 第一块的索引
/// @param secondIndex 第二块的索引
- (void)setFirstIndex:(NSInteger)firstIndex secondIndex:(NSInteger)secondIndex;


@end

NS_ASSUME_NONNULL_END
