//
//  QGCardRequestApi.m
//  VirtualPayment
//
//  Created by 张博 on 2019/7/3.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGCardRequestApi.h"

@implementation QGCardRequestApi

/*
 接口URL
 */
+ (NSString *)urlWithIndex:(QGCardRequestServerMethod)index
{
    NSString * urlString = @"";
    switch (index) {
            ///享花卡状态接口
        case QGCardRequestServerMethodBlanknoteStatus:
            urlString = @"vcc/mvp/index/v3";
            break;
            ///激活按钮应该请求的接口
        case QGCardRequestServerMethodActiveUrl:
            urlString = @"vcc/account/active_url";
            break;
            ///提额页面接口
        case QGCardRequestServerMethodCreditInfo:
            urlString = @"vcc/account/credit_info";
            break;
            ///三组分期选择
        case QGCardRequestServerMethodSelectTermsDetail:
            urlString = @"vcc/mvp/user/selectTerms/detail";
            break;
            ///可配置分期组用户更新分期
        case QGCardRequestServerMethodUserTermsUpdate:
            urlString = @"vcc/mvp/userTerms/update";
            break;
            ///绑定钱包接口
        case QGCardRequestServerMethodBindWalletStep:
            urlString = @"vcc/mvp/bindWalletStep";
            break;
            ///缓存用户IP和mac地址
        case QGCardRequestServerMethodCacheIpMacAddress:
            urlString = @"vcc/account/cache/user/ipMacAddress";
            break;
            ///开启返现
        case QGCardRequestServerMethodReturnCashSigned:
            urlString = @"vcc/mvp/returnCash/signed";
            break;
        case QGCardRequestServerMethodActivity:
            urlString = @"vcc/app/config/windows";
            break;
            ///检查更新
        case QGCardRequestServerMethodAPPUpdata:
            urlString = @"vcc/app/config/version";
            break;
            ///获取激活额度跳转URL
        case QGCardRequestServerMethodActiveCreditUrl:
            urlString = @"vcc/account/active_credit_limit_url";
            break;
            //立即申请额度时请求的接口
        case QGCardRequestServerMethodActiveCreditApply:
            urlString = @"vcc/account/active_credit_limit";
            break;
            ///交易设置查询
        case QGCardRequestServerMethodTransactionSettings:
            urlString = @"vcc/trade/deduction_account/query";
            break;
            ///交易设置保存
        case QGCardRequestServerMethodSaveSetting:
            urlString = @"vcc/trade/deduction_account/setting";
            break;
            ///查询储蓄账户信息
        case QGCardRequestServerMethodSavingsAccountQuery:
            urlString = @"vcc/debit/account_balance/query";
            break;
        default:
            break;
    }
    return urlString;
}

@end
