//
//  QGTransactionSetController.m
//  VirtualPayment
//
//  Created by 张博 on 2020/4/3.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGTransactionSetController.h"

#import "QGCardRequestApi.h"

#import "QGTransactionSettingsModel.h"

#import "QGTransactionSettingsCell.h"
#import "QGTransactionTipsCell.h"


@interface QGTransactionSetController ()

/// 交易设置数据
@property (nonatomic, strong) QGTransactionSettingsModel * settingsModel;

/// 选中的交易配置
@property (nonatomic, strong) QGSettingsConfigModel * selectConfigModel;
@end

@implementation QGTransactionSetController

- (BOOL)checkParameters:(NSDictionary *)param
{
    return YES;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.title = @"交易设置";
    [self custemLeftDefaultBarButtonItem];
    self.tableView.backgroundColor = [UIColor moduleSeparatorColorF7F7];
    [self requestData];
}

#pragma mark - Request
- (void)requestData
{
    NSString * urlString = [QGCardRequestApi urlWithIndex:QGCardRequestServerMethodTransactionSettings];
//    urlString = @"http://yapi.quantgroups.com/mock/305/vcc/trade/deduction_account/query";
    [QGHUDManager showHud:nil];
    [[QGTalosNetwork shareManager] GET:urlString parameters:nil success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            self.settingsModel = [QGTransactionSettingsModel yy_modelWithDictionary:responseObject[@"data"]];
            for (QGSettingsConfigModel * configModel in self.settingsModel.configList) {
                if (configModel.choose.boolValue) {
                    self.selectConfigModel = configModel;
                    break;
                }
            }
            [self.tableView reloadData];
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
    }];
}

- (void)requestSaveSettingWithConfig:(QGSettingsConfigModel *)configModel
{
    
    //埋点
    QGAppCoreModelClickEvent * event = [QGAppCoreModelClickEvent acmcEventWithPage:@"交易设置" path:@"交易设置" name:@"交易设置管理" detail_name:configModel.name];
    [QGAnalyticsService analyticsTrackWithEvent:event];
    
    
    NSString * urlString = [QGCardRequestApi urlWithIndex:QGCardRequestServerMethodSaveSetting];
//    urlString = @"http://yapi.quantgroups.com/mock/305/vcc/trade/deduction_account/setting";
    [QGHUDManager showHud:nil];
    NSDictionary * param = @{@"deductionType" : configModel.deductionType};
    [[QGTalosNetwork shareManager] POST:urlString parameters:param success:^(id  _Nonnull responseObject) {
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            [QGHUDManager showHud:@"设置成功"];
            self.selectConfigModel = configModel;
            [self.tableView reloadData];
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
    }];
}

#pragma mark - UITableViewDataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return self.settingsModel ? 3 : 0;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    NSInteger numberOfRows = 1;
    switch (section) {
        case 1:
            numberOfRows = self.settingsModel.configList.count;
            break;
            
        default:
            break;
    }
    return numberOfRows;
}

- (UITableViewCell * )tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell * cell;
    switch (indexPath.section) {
            //顶部提示
        case 0:
            {
                QGTransactionTipsCell * tipCell = (QGTransactionTipsCell *)[self getCellFromClassName:NSStringFromClass([QGTransactionTipsCell class]) dequeueTableView:tableView];
                tipCell.tipLabel.text = self.settingsModel.topDescStr;
                cell = tipCell;
            }
            break;
            //交易可选项
        case 1:
            {
                QGTransactionSettingsCell * settingsCell = (QGTransactionSettingsCell *)[self getCellFromClassName:NSStringFromClass([QGTransactionSettingsCell class]) dequeueTableView:tableView];
                settingsCell.configModel = self.settingsModel.configList[indexPath.row];
                cell = settingsCell;
            }
            break;
            //底部提示
        case 2:
            {
                QGTransactionTipsCell * tipCell = (QGTransactionTipsCell *)[self getCellFromClassName:NSStringFromClass([QGTransactionTipsCell class]) dequeueTableView:tableView];
                cell = tipCell;
                tipCell.tipLabel.text = self.settingsModel.tip;
            }
            break;
            
        default:
            break;
    }
    return cell ? cell : [UITableViewCell new];
}

#pragma mark - UITableViewDelegate
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CGFloat heightForRow = 0;
    switch (indexPath.section) {
            //顶部提示
        case 0:
            {
                heightForRow = self.settingsModel.topDescHeight;
            }
            break;
            //交易可选项
        case 1:
            {
                heightForRow = 72;
            }
            break;
            //底部提示
        case 2:
            {
                heightForRow = self.settingsModel.bottomTipHeight;
            }
            break;
            
        default:
            break;
    }
    return heightForRow;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    //交易配置选项
    if (indexPath.section == 1) {
        QGSettingsConfigModel * configModel = self.settingsModel.configList[indexPath.row];
        //剔除不可用的选项 和 相等的选项
        if (configModel.canUse.boolValue && self.selectConfigModel != configModel) {
            [self requestSaveSettingWithConfig:configModel];
        }
    }
}

#pragma mark - Setter
- (void)setSelectConfigModel:(QGSettingsConfigModel *)selectConfigModel
{
    if (_selectConfigModel != selectConfigModel) {
        //重置选中关系
        _selectConfigModel.choose = @"0";
        _selectConfigModel = selectConfigModel;
        _selectConfigModel.choose = @"1";
    }
}


@end
