//
//  QGTransactionSettingsCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/4/3.
//  Copyright © 2020 bo.zhang. All rights reserved.
//


#import "QGTransactionSettingsCell.h"
#import "QGBasicUITool.h"

@interface QGTransactionSettingsCell ()

/// 标题
@property (nonatomic, strong) UILabel * titleLabel;

/// 选择状态
@property (nonatomic, strong) UIImageView * selectImgView;

@end

@implementation QGTransactionSettingsCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        self.contentView.backgroundColor = [UIColor moduleSeparatorColorF7F7];
        //白色背景
        UIView * whiteView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor whiteColor]];
        [whiteView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.inset(0);
            make.height.mas_equalTo(62);
        }];
        
        //标题
        self.titleLabel = [UILabel creatLabelWithSuperView:whiteView title:nil titleFontSize:[UIFont qg_regularFontOfSize:17] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(20);
            make.height.mas_equalTo(24);
            make.centerY.offset(0);
        }];
        
        //选择状态
        self.selectImgView = [UIImageView creatImageViewWithSuperView:whiteView imageName:@"notSelect"];
        [self.selectImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(15);
            make.size.mas_equalTo(CGSizeMake(16, 16));
            make.centerY.offset(0);
        }];
        
    }
    return self;
}


- (void)setConfigModel:(QGSettingsConfigModel *)configModel
{
    if (_configModel != configModel) {
        _configModel = configModel;
        self.titleLabel.text = configModel.name;
        self.titleLabel.textColor = configModel.canUse.boolValue ? [UIColor textColor3333] : [UIColor textColor9999];
    }
    NSString * imageName = configModel.choose.boolValue ? @"selected" : @"notSelect";
    self.selectImgView.image = [UIImage imageNamed:imageName];
    
    
    
}


@end
