//
//  QGSelectTermHeaderItemCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/9/23.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGSelectTermHeaderItemCell.h"
#import "QGBasicUITool.h"
#import "QGGradientView.h"

@interface QGSelectTermHeaderItemCell ()

/// 标题
@property (nonatomic, strong) UILabel * titleLabel;

/// 描述
@property (nonatomic, strong) UILabel * descLabel;

/// 渐变色层
@property (nonatomic, strong) QGGradientView * gradientView;

@end

@implementation QGSelectTermHeaderItemCell

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        //边框层
        UIView * borderView = [UIView creatViewWithSuperView:self.contentView backgroundColor:nil];
        [borderView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.bottom.offset(0);
        }];
        [borderView setBorder:[UIColor lineSeparatorColorDCDC] width:1];
        borderView.layer.cornerRadius = 3;
        borderView.clipsToBounds = YES;
        
        //渐变层
        self.gradientView = [[QGGradientView alloc] init];
        self.gradientView.layer.cornerRadius = 3;
        self.gradientView.clipsToBounds = YES;
        self.gradientView.hidden = YES;
        [self.contentView addSubview:self.gradientView];
        [self.gradientView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.bottom.offset(0);
        }];
        
        
        //中心视图
        UIView * centerView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor clearColor]];
        [centerView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.center.offset(0);
            make.width.mas_equalTo(self.contentView);
        }];
        
        
        //标题
        self.titleLabel = [UILabel creatLabelWithSuperView:centerView title:nil titleFontSize:[UIFont qg_mediumFontOfSize:16] textColor:[UIColor textColor3333] alignment:NSTextAlignmentCenter];
        self.titleLabel.numberOfLines = 0;
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(0);
            make.top.inset(3);
            make.height.greaterThanOrEqualTo(@(22));
        }];
        
        //详情
        self.descLabel = [UILabel creatLabelWithSuperView:centerView title:nil titleFontSize:[UIFont qg_regularFontOfSize:12] textColor:[UIColor textColor9999] alignment:NSTextAlignmentCenter];
        self.descLabel.numberOfLines = 0;
        [self.descLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(0);
            make.top.mas_equalTo(self.titleLabel.mas_bottom).offset(3);
            make.bottom.inset(3);
        }];
        
        
    }
    return self;
}



- (void)setCanSelectTerm:(QGCanSelectTermModel *)canSelectTerm
{
    if (_canSelectTerm != canSelectTerm) {
        _canSelectTerm = canSelectTerm;
        
        if (canSelectTerm.term.intValue == 1) {
            self.titleLabel.text = @"不分期";
            self.descLabel.text = [NSString stringWithFormat:@"手续费率%@",canSelectTerm.termRate];
        }
        else
        {
            self.titleLabel.text = [NSString stringWithFormat:@"分%@期",canSelectTerm.term];
            self.descLabel.text = [NSString stringWithFormat:@"每期手续费率%@",canSelectTerm.termRate];
        }
        
        
    }
    
    if (_canSelectTerm.selectedTerm) {
        self.titleLabel.textColor = [UIColor whiteColor];
        self.descLabel.textColor = [UIColor whiteColor];
        self.gradientView.hidden = NO;
    }
    else
    {
        self.titleLabel.textColor = [UIColor textColor3333];
        self.descLabel.textColor = [UIColor textColor9999];
        self.gradientView.hidden = YES;
    }
    
}


@end
