//
//  QGSelectTermHeaderCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/9/23.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGSelectTermHeaderCell.h"
#import "QGSelectTermHeaderItemCell.h"
#import "QGBasicUITool.h"
@interface QGSelectTermHeaderCell ()<UICollectionViewDelegate, UICollectionViewDataSource>

/// 提示标题
@property (nonatomic, strong) UILabel * titleLabel;

/// 选择分期区域
@property (nonatomic, strong) UICollectionView * collectionView;



@end

@implementation QGSelectTermHeaderCell


- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        //顶部标题
        UIView * headerView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor moduleSeparatorColorF7F7]];
        [headerView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.inset(0);
            make.height.mas_equalTo(40);
        }];
        
        //提示标题
        self.titleLabel = [UILabel creatLabelWithSuperView:headerView title:nil titleFontSize:[UIFont qg_regularFontOfSize:12] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.top.bottom.offset(0);
        }];
        [headerView addSubview:self.titleLabel];
        
        //选择分期区域
        UICollectionViewFlowLayout * layout = [[UICollectionViewFlowLayout alloc]init];
        layout.itemSize = CGSizeMake((MAINSCREEN_WIDTH - 20 * 2 - 10 * 2)/3.0, 80);
        layout.minimumLineSpacing = 20;
        layout.minimumInteritemSpacing = 10;
        
        self.collectionView = [[UICollectionView alloc] initWithFrame:CGRectZero collectionViewLayout:layout];
        self.collectionView.dataSource = self;
        self.collectionView.delegate = self;
        self.collectionView.backgroundColor = [UIColor whiteColor];
        [self.contentView addSubview:self.collectionView];
        
        [self.collectionView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.top.mas_equalTo(headerView.mas_bottom).offset(20);
            make.bottom.inset(39);
        }];
        
        [self.collectionView registerClass:[QGSelectTermHeaderItemCell class] forCellWithReuseIdentifier:NSStringFromClass([QGSelectTermHeaderItemCell class])];
        
    }
    return self;
}


- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return self.canConfigTermsDetail.canSelectTerms.count;
}

- (__kindof UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    QGSelectTermHeaderItemCell * cell = (QGSelectTermHeaderItemCell *)[collectionView dequeueReusableCellWithReuseIdentifier:NSStringFromClass([QGSelectTermHeaderItemCell class]) forIndexPath:indexPath];
    cell.canSelectTerm = self.canConfigTermsDetail.canSelectTerms[indexPath.row];
    return cell;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    self.currentSelectTerm = self.canConfigTermsDetail.canSelectTerms[indexPath.row];
    [self.collectionView reloadData];
}

- (void)setCanConfigTermsDetail:(QGCanConfigTermsDetailModel *)canConfigTermsDetail
{
    if (_canConfigTermsDetail != canConfigTermsDetail) {
        _canConfigTermsDetail = canConfigTermsDetail;
        
        self.titleLabel.text = [NSString stringWithFormat:@"当消费金额小于%@元时，系统默认不分期",canConfigTermsDetail.termAmountThreshold];
        [self.collectionView reloadData];
    }
}


- (void)setCurrentSelectTerm:(QGCanSelectTermModel *)currentSelectTerm
{
    if (_currentSelectTerm != currentSelectTerm) {
        _currentSelectTerm.selectedTerm = NO;
        _currentSelectTerm = currentSelectTerm;
        _currentSelectTerm.selectedTerm = YES;
        
        if (self.selectCallback) {
            self.selectCallback(_currentSelectTerm);
        }
    }
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
