//
//  QGSelectTermDescCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/9/23.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGSelectTermDescCell.h"
#import "QGBasicUITool.h"
@interface QGSelectTermDescCell ()

/// 息费说明内容
@property (nonatomic, strong) UILabel * rateInfoLabel;

/// 举例说明
@property (nonatomic, strong) UILabel * exampleDescLabel;
@end


@implementation QGSelectTermDescCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        //线条
        UIView * lineView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor lineSeparatorColorDCDC]];
        [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.top.inset(0);
            make.height.mas_equalTo(0.5);
        }];
        
        //息费标题
        UILabel * rateTitleLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"息费说明" titleFontSize:[UIFont qg_mediumFontOfSize:16] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [rateTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.top.offset(20);
            make.height.mas_equalTo(22);
        }];
        
        //息费说明内容
        self.rateInfoLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_lightFontOfSize:12] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        self.rateInfoLabel.numberOfLines = 0;
        [self.rateInfoLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.top.mas_equalTo(rateTitleLabel.mas_bottom).offset(11);
        }];
        
        //例如
        UILabel * exampleTitleLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"例如" titleFontSize:[UIFont qg_mediumFontOfSize:12] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [exampleTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.top.mas_equalTo(self.rateInfoLabel.mas_bottom).offset(14);
            make.height.mas_equalTo(20);
        }];
        
        //例如详情
        self.exampleDescLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:self.rateInfoLabel.font textColor:self.rateInfoLabel.textColor alignment:NSTextAlignmentLeft];
        self.exampleDescLabel.numberOfLines = 0;
        [self.exampleDescLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.top.mas_equalTo(exampleTitleLabel.mas_bottom).offset(5);
        }];
        
    }
    return self;
}


- (void)setCanConfigTermsDetail:(QGCanConfigTermsDetailModel *)canConfigTermsDetail
{
    if (_canConfigTermsDetail != canConfigTermsDetail) {
        _canConfigTermsDetail = canConfigTermsDetail;
        
        self.rateInfoLabel.text = _canConfigTermsDetail.canConfigTermContentFeeDesc;
        self.exampleDescLabel.text = _canConfigTermsDetail.canConfigTermContentEx;
    }
}



- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
