//
//  QGAmountDescView.m
//  VirtualPayment
//
//  Created by 张博 on 2019/9/29.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGAmountDescPopView.h"
#import "QGBasicUITool.h"
@interface QGAmountDescPopView ()


@end

@implementation QGAmountDescPopView

+ (void)showAmountDescVewWithAmountTitle:(NSString *)amountTitle amount:(NSString *)amount amountDesc:(NSString *)amountDesc
{
    QGAmountDescPopView * popView = [[QGAmountDescPopView alloc] initWithAmountTitle:amountTitle amount:amount amountDesc:amountDesc];
    [popView showInView:nil];
}


- (instancetype)initWithAmountTitle:(NSString *)amountTitle amount:(NSString *)amount amountDesc:(NSString *)amountDesc
{
    if (self = [super initWithFrame:CGRectZero]) {
        
        self.popType = PopViewTypeActionSheet;
        
        //标题
        UILabel * titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:amountTitle titleFontSize:[UIFont qg_regularFontOfSize:13] textColor:[UIColor textColor9999] alignment:NSTextAlignmentCenter];
        [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.top.inset(0);
            make.height.mas_equalTo(50);
        }];
        
        //关闭
        UIButton * closeButton = [UIButton creatButtonWithSuperView:self.contentView title:nil titleFont:nil textColor:nil];
        [closeButton setImage:[UIImage imageNamed:@"vc_close"] forState:UIControlStateNormal];
        [closeButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.right.inset(0);
            make.size.mas_equalTo(CGSizeMake(50, 50));
        }];
        
        @weakify(self);
        [closeButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
            @strongify(self);
            [self dismissView:nil];
        }];
        
        
        //分割线
        UIView * topLine = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor lineSeparatorColorDCDC]];
        [topLine mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(0);
            make.height.mas_equalTo(0.5);
            make.top.mas_equalTo(titleLabel.mas_bottom).offset(0);
        }];
        
        //总计
        UILabel * leftTitleLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"总计" titleFontSize:[UIFont qg_lightFontOfSize:14] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        [leftTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.offset(20);
            make.top.mas_equalTo(topLine.mas_bottom).offset(23);
            make.height.mas_equalTo(20);
        }];
        
        //金额
        UILabel * amountLabel = [UILabel creatLabelWithSuperView:self.contentView title:[NSString stringWithFormat:@"%.2f元",amount.floatValue] titleFontSize:[UIFont qg_regularFontOfSize:14] textColor:[UIColor textColor3333] alignment:NSTextAlignmentRight];
        [amountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(20);
            make.centerY.mas_equalTo(leftTitleLabel.mas_centerY);
        }];
        
        //中间线
        UIView * centerLine = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor lineSeparatorColorDCDC]];
        [centerLine mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.height.mas_equalTo(0.5);
            make.top.mas_equalTo(leftTitleLabel.mas_bottom).offset(15);
        }];
        
        //小标题
        UILabel * subTitleLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"费用说明" titleFontSize:[UIFont qg_lightFontOfSize:14] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [subTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.offset(20);
            make.height.mas_equalTo(20);
            make.top.mas_equalTo(centerLine.mas_bottom).offset(15);
        }];
        
        //描述
        UILabel * descLabel = [UILabel creatLabelWithSuperView:self.contentView title:amountDesc titleFontSize:[UIFont qg_lightFontOfSize:14] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        descLabel.numberOfLines = 0;
        [descLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.top.mas_equalTo(subTitleLabel.mas_bottom).offset(9);
            make.bottom.inset(60);
        }];
        
    }
    return self;
}



@end
