//
//  QGRepaymentStagesViewCell.m
//  VirtualPayment
//
//  Created by silicn on 2019/6/24.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGRepaymentStagesViewCell.h"

#import "QGBasicUITool.h"

#import "QGRepaymentPieView.h"

#import "QGRepaymentAmortizeOrderModel.h"


@interface QGRepaymentStagesViewCell()
///饼视图
@property (nonatomic, strong)QGRepaymentPieView *pieView;
///分期数 当前期数/总期数
@property (nonatomic, strong) UILabel *stageLab;
///商品名字
@property (nonatomic, strong) UILabel *nameLab;
///金额 精确到小数点后2位
@property (nonatomic, strong) UILabel *amountLab;
/////账单类型 比如订单分期，账单分期  弃用
//@property (nonatomic, strong) UILabel *subTextLab;
/// 订单状态  一般情况是已退货
@property (nonatomic, strong) UILabel *statusLab ;

/// 优惠金额
@property (nonatomic, strong) UILabel *cheapLab ;

@end

@implementation QGRepaymentStagesViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style
                reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setups];
    }
    return self;
}


- (void)setups
{
    /// 饼状图
    self.pieView = [[QGRepaymentPieView alloc]init];
    [self.contentView addSubview:_pieView];
    [self.pieView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.equalTo(self.contentView).inset(20);
        make.width.height.mas_equalTo(15);
    }];
    // 1/6期
    self.stageLab = [UILabel creatLabelWithSuperView:self.contentView title:@"第*/*期" titleFontSize:[UIFont qg_lightFontOfSize:14.0f] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
    /// 消费商品明细
    self.nameLab = [UILabel creatLabelWithSuperView:self.contentView title:@"商品名称" titleFontSize:[UIFont qg_lightFontOfSize:14.0f] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
    /// 消费金额
    self.amountLab = [UILabel creatLabelWithSuperView:self.contentView title:@"00.00元" titleFontSize:[UIFont qg_regularFontOfSize:14.0f] textColor:[UIColor textColor3333] alignment:NSTextAlignmentRight];

    /// 是否有退货
    self.statusLab = [UILabel creatLabelWithSuperView:self.contentView title:@" " titleFontSize:[UIFont qg_mediumFontOfSize:12.0f] textColor:[UIColor textColor3333] alignment:NSTextAlignmentRight];
    // 优惠金额
    self.cheapLab = [UILabel creatLabelWithSuperView:self.contentView title:@" " titleFontSize:[UIFont qg_lightFontOfSize:10.f] textColor:UIColor.yyMainThemeColor alignment:NSTextAlignmentRight];
    
    [self.stageLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.pieView.mas_right).offset(8);
        make.top.equalTo(self.contentView).inset(18);
        make.right.greaterThanOrEqualTo(self.nameLab.mas_left);
    }];
    
   [self.nameLab mas_makeConstraints:^(MASConstraintMaker *make) {
         make.left.equalTo(self.stageLab);
         make.top.equalTo(self.pieView.mas_bottom).offset(6);
         make.right.equalTo(self.amountLab.mas_left).offset(-8);
     }];
   
    
    [self.amountLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.equalTo(self.contentView).inset(20);
        make.centerY.equalTo(self.nameLab);
    }];
    
    [self.statusLab mas_makeConstraints:^(MASConstraintMaker *make) {
              make.right.equalTo(self.amountLab);
              make.centerY.equalTo(self.stageLab);
    }];
    
//    [self.nameLab mas_makeConstraints:^(MASConstraintMaker *make) {
//        make.left.equalTo(self.contentView).inset(128);
//        make.right.equalTo(self.amountLab.mas_left).offset(-8);
//        make.centerY.equalTo(self.stageLab);
//    }];
    
    
    self.arrowHide = YES;
    
   
    
    [self.cheapLab mas_makeConstraints:^(MASConstraintMaker *make) {
          make.top.equalTo(self.nameLab.mas_bottom).offset(4);
          make.right.equalTo(self.amountLab);
          make.bottom.equalTo(self.contentView).inset(10);
      }];
}

- (void)setModel:(QGRepaymentAmortizeOrderModel *)model
{
    _model = model;
    _pieView.percent = model.currTerm/(CGFloat)model.term;
    _stageLab.text = [NSString stringWithFormat:@"第%ld/%ld期",(long)model.currTerm,(long)model.term];
    _nameLab.text = model.orderName;
    _amountLab.text = [NSString stringWithFormat:@"%@元",model.orderAmount];
    _cheapLab.text = model.couponInfo;
//    _subTextLab.text = model.installmentType ? @"订单分期" :@"账单分期";
    
    _statusLab.text = model.refundFlag ? model.refundFlag:@"";
}


+ (instancetype)initWithTableView:(UITableView *)tableView
{
    static NSString *identifier = @"QGRepaymentStagesViewCell";
    
    QGRepaymentStagesViewCell *cell = [tableView dequeueReusableCellWithIdentifier:identifier];
    if (cell == nil) {
        [tableView registerClass:[QGRepaymentStagesViewCell class] forCellReuseIdentifier:identifier];
        cell = [[QGRepaymentStagesViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:identifier];
    }
    return cell;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
