//
//  QGRepaymentSectionCell.m
//  VirtualPayment
//
//  Created by silicn on 2019/6/26.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGRepaymentSectionCell.h"
#import "QGBasicUITool.h"
#import "QGRepaymentBillSectionModel.h"


@interface QGRepaymentSectionCell()

@property (nonatomic, strong)UILabel *titleLab;

/// 入账周期
@property (nonatomic, strong) UILabel * billTradeCycleLabel;
@end

@implementation QGRepaymentSectionCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        [self setups];
    }
    return self;
}

- (void)setups
{
    self.separateLineHide = YES;
    self.arrowHide = YES;
    self.titleLab = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_mediumFontOfSize:16.0f] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
    [self.titleLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.contentView).inset(20);
        make.top.equalTo(self.contentView).inset(30);
        make.bottom.equalTo(self.contentView).inset(0);
    }];
    
    //入账周期
    self.billTradeCycleLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_lightFontOfSize:12] textColor:[UIColor textColor9999] alignment:NSTextAlignmentRight];
    [self.billTradeCycleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.inset(20);
        make.bottom.mas_equalTo(self.titleLab);
    }];
                     
}

- (void)setModel:(QGRepaymentBillSectionModel *)model
{
    if (_model != model) {
        _model = model;
        self.titleLab.text = model.title;
        self.titleLab.font = [UIFont qg_mediumFontOfSize:model.smallFont ? 14.0f:16.0f];
        
        if (![NSString isEmpty:model.descText]) {
            self.billTradeCycleLabel.text = [NSString stringWithFormat:@"入账周期：%@",model.descText];
        }
        else
        {
            self.billTradeCycleLabel.text = @"";
        }
        
//        if (model.smallFont) {
//            [self.titleLab mas_updateConstraints:^(MASConstraintMaker *make) {
//                make.top.equalTo(self.contentView).inset(18);
//                make.bottom.equalTo(self.contentView).inset(2);
//            }];
//        }else{
//            [self.titleLab mas_updateConstraints:^(MASConstraintMaker *make) {
//                make.top.bottom.equalTo(self.contentView).inset(10);
//            }];
//        }
    }
}

+ (instancetype)initWithTableView:(UITableView *)tableView
{
    static NSString *identifier = @"QGRepaymentSectionCell";
    
    QGRepaymentSectionCell *cell = [tableView dequeueReusableCellWithIdentifier:identifier];
    if (cell == nil) {
        [tableView registerClass:[QGRepaymentSectionCell class] forCellReuseIdentifier:identifier];
        cell = [[QGRepaymentSectionCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:identifier];
    }
    return cell;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
