//
//  QGRepaymentHeadView.m
//  VirtualPayment
//
//  Created by silicn on 2019/6/20.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGRepaymentListView.h"
#import "QGPaymentStatusView.h"

#import "QGBasicUITool.h"
#import "UIView+Extend.h"

#import "QGRepayGradientView.h"

#import "QGRepaymentListViewCell.h"

#import "QGBlurEffectView.h"

#import "QGHitTestView.h"

#define kAnimationTime 0.25f

@interface QGRepaymentListView()<UITableViewDelegate,UITableViewDataSource>
/// huge 毛玻璃
@property (nonatomic, strong)QGBlurEffectView *backgroundView;
/// 白色背景
@property (nonatomic, strong)UIView *whiteView;
/// 已还清状态下的Item,点击下拉可视区域
@property (nonatomic, strong)UITableView *tableView;
/// 进入可视的账单状态区域
@property (nonatomic, strong)QGPaymentStatusView *footerView;

@property (nonatomic, assign)CGFloat tableView_height;

///隐藏的条目，不设置默认无
@property (nonatomic, strong)NSMutableArray *items;


@end

@implementation QGRepaymentListView

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setups];
    }
    return self;
}

- (void)pan {
}

- (void)setups
{
    self.backgroundColor = [UIColor clearColor];
    /// 截断tabelView的手势响应
    UIPanGestureRecognizer *pan = [[UIPanGestureRecognizer alloc]initWithTarget:self action:@selector(pan)];
    [self addGestureRecognizer:pan];
    
    self.clipsToBounds = YES;
    //设置玻璃效果 HUGE
    self.backgroundView = [[QGBlurEffectView alloc]init];
    self.backgroundView.hidden = YES;
    [self addSubview:_backgroundView];
    
    [self.backgroundView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.bottom.equalTo(self);
        make.top.equalTo(self).inset(120);
    }];
    
    @weakify(self)
    self.backgroundView.tapBlock = ^{
        @strongify(self);
        [self.footerView resetUpOrDownStatus];
        [self scrollWhiteViewToUp];
    };
    
    // 白色背景
    self.whiteView = [UIView creatViewWithSuperView:self backgroundColor:[UIColor whiteColor]];
    [self.whiteView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.equalTo(self).inset(20.0f);
        make.top.equalTo(self.mas_top);
    }];
    [self.whiteView setShadowColor:[UIColor colorWithHexString:@"372D2D" alpha:0.2] shadowRadius:2 shadowOffset:CGSizeMake(0, 2) cornerRadius:2];
    
    [self.whiteView addSubview:self.tableView];
    
    [self.tableView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.whiteView.mas_top);
        make.left.bottom.right.equalTo(self.whiteView);
    }];
    
    // FootView
    self.footerView = [[QGPaymentStatusView alloc]initWithFrame:CGRectMake(0, 0, self.tableView.frame.size.width, 170)];

    self.tableView.tableFooterView = self.footerView;
    
    self.footerView.block = ^(BOOL isDown) {
        @strongify(self)
        if (isDown) {
            [self scrollWhiteViewToDown];
        }else{
            ///回收全屏透明的点击视图
            [self scrollWhiteViewToUp];
        }
    };
    
    ///待还金额详情页
    self.footerView.showAmountDetailBolck = ^{
        @strongify(self);
        if (self.showAmountDetailBolck) {
            self.showAmountDetailBolck();
        }
    };
    
    // 设置白色顶部灰色渐变图层
    QGRepayGradientView *head = [[QGRepayGradientView alloc]init];
    [self addSubview:head];
    
    [head mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.equalTo(self).inset(20);
        make.top.equalTo(self.mas_top);
        make.height.mas_equalTo(15);
    }];
}

#pragma mark - WhiteView 上下滑动

- (void)scrollWhiteViewToDown
{
    [self.backgroundView showWithDuration:kAnimationTime];
    /// 向下滑动
    [UIView animateWithDuration:kAnimationTime animations:^{
        self.whiteView.y = 0;
    } completion:^(BOOL finished) {
        [self.whiteView mas_updateConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(self.mas_top);
        }];
    }];
    [self.whiteView layoutIfNeeded];
    /// 白色视图出现，可以点击
    if (self.canClickBlock) {
        self.canClickBlock(YES);
    }
}

- (void)scrollWhiteViewToUp
{
    ///回收全屏透明的点击视图
    [self.backgroundView hiddenWithDuration:kAnimationTime];
    ///向上滑动
    [UIView animateWithDuration:kAnimationTime animations:^{
        self.whiteView.y = self.footerView.height - self.whiteView.height;
    } completion:^(BOOL finished) {
        [self.whiteView mas_updateConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(self.mas_top).inset(self.footerView.height - self.whiteView.height);
        }];
    }];
    // 白色视图隐藏，不可以点击
    if (self.canClickBlock) {
        self.canClickBlock(NO);
    }
}

#pragma mark - TableView


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.items.count;
}

// Row display. Implementers should *always* try to reuse cells by setting each cell's reuseIdentifier and querying for available reusable cells with dequeueReusableCellWithIdentifier:
// Cell gets various attributes set automatically based on table (separators) and data source (accessory views, editing controls)

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    QGRepaymentListViewCell *cell = [QGRepaymentListViewCell initWithTableView:self.tableView];
    cell.item = self.items[indexPath.row];
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    if (self.touchItemBlock) {
        self.touchItemBlock(self.items[indexPath.row]);
    }
}


- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return 0.01f;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 0.01f;
}

#pragma mark -  TableView DataSource


/// 根据model设置头部list的Items
/// @param model 当月账单QGRepaymentBillModel
- (void)setupItemsWithModel:(QGRepaymentBillModel *)model
{
     [self.items removeAllObjects];
    // 只有已还清状态有items
    if (model.status  != -1) {
        /// 当月账单总额
        NSString *name = [NSString stringWithFormat:@"%@月账单",model.month];
        QGRepaymentStatusBillItem *totalItem = [[QGRepaymentStatusBillItem alloc]init];
        totalItem.title = name;
        totalItem.content = [NSString stringWithFormat:@"%@元",model.amount];
        [self.items addObject:totalItem];
        /// 退款金额
        if (model.refundInfo && [model.refundInfo[@"amount"] floatValue] > 0) {
            QGRepaymentStatusBillItem *repayItem = [[QGRepaymentStatusBillItem alloc]init];
            repayItem.title = @"退款";
            repayItem.content = [NSString stringWithFormat:@"-%@元",model.refundInfo[@"amount"]];
            repayItem.url = model.refundInfo[@"url"];
            [self.items addObject:repayItem];
        }
        /// 已还金额
        if (model.repayInfo && [model.repayInfo[@"amount"] floatValue] > 0) {
            QGRepaymentStatusBillItem *repayItem = [[QGRepaymentStatusBillItem alloc]init];
            repayItem.title = @"已还";
            repayItem.content = [NSString stringWithFormat:@"-%@元",model.repayInfo[@"amount"]];
            repayItem.url = model.repayInfo[@"url"];
            [self.items addObject:repayItem];
        }
        ///账单分期
        if (model.installmentInfo && [model.installmentInfo[@"amount"] floatValue] > 0) {
            QGRepaymentStatusBillItem *instalmentItem = [[QGRepaymentStatusBillItem alloc]init];
            instalmentItem.title = @"账单分期";
            instalmentItem.content = [NSString stringWithFormat:@"%@元",model.installmentInfo[@"amount"]];
            instalmentItem.url = model.installmentInfo[@"url"];
            [self.items addObject:instalmentItem];
        }
    }
    /// 改变whiteView 的高度
    [self updateTableViewFrame];
}

- (void)setModel:(QGRepaymentBillModel *)model
{
    if (_model != model) {
        _model = model;
        [self setupItemsWithModel:model];
        self.footerView.statusModel = model;
    }
}


/// 隐藏默认透明视图
- (void)dismissBlurEffectView
{
    [self.footerView resetUpOrDownStatus];
    [self scrollWhiteViewToUp];
}


/**
 根据items的数量重新布局约束
 */
- (void)updateTableViewFrame
{
    [self.tableView reloadData];
    
    [self.whiteView mas_updateConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.mas_top).inset(-self.tableView.contentSize.height - 10);
    }];
    
    /// 更新TableView的高度,也会重置whiteView的高度
    [self.tableView mas_updateConstraints:^(MASConstraintMaker *make) {
        make.height.mas_equalTo(self.tableView.contentSize.height);
    }];
    // 重置whiteView的位置
    [self.whiteView layoutIfNeeded];

    
    [self scrollWhiteViewToUp];
    
    
}


- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc]initWithFrame:CGRectZero style:UITableViewStylePlain];
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.scrollEnabled = NO;
        _tableView.scrollsToTop = NO;
        _tableView.backgroundColor = [UIColor whiteColor];
        _tableView.rowHeight = 60;
        _tableView.estimatedRowHeight = 60;
        _tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    }
    return _tableView;
}

- (NSMutableArray *)items
{
    if (_items == nil) {
        _items = [NSMutableArray array];
    }
    return _items;
}


/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
