//
//  QGRepaymentBottomView.h
//  VirtualPayment
//
//  Created by silicn on 2019/6/24.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>

@class QGRepaymentBillHeadModel;


NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger,RepaymentBottomType){
    RepaymentBottomTypeNomal, // 常规两个，左白色，右渐变
    RepaymentBottomTypeSignle //一个渐变
};

typedef void (^RepaymentBottomActionBlock)(BOOL isRight);

@interface QGRepaymentBottomView : UIView

@property (nonatomic, assign) RepaymentBottomType type;
/// 是否可以交互 默认可以交互：YES
@property (nonatomic, assign) BOOL canUserExpress;
/**
 设置左右title

 @param leftTitle 左边button Title
 @param rightTitle 右边button Title
 */
- (void)setLeftTitle:(nullable NSString *)leftTitle rightTitle:(nullable NSString *)rightTitle;

/// 底部button的点击事件
@property (nonatomic, copy)RepaymentBottomActionBlock actionBlock;
/// 头部Model
@property (nonatomic, strong)QGRepaymentBillHeadModel *billHeadModel;

@end

NS_ASSUME_NONNULL_END
