//
//  QGRepaymentBackgroundView.m
//  VirtualPayment
//
//  Created by silicn on 2019/6/27.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGRepaymentBackgroundView.h"

#import "QGBasicUITool.h"


@interface QGRepaymentBackgroundView()

@property (nonatomic, strong)UILabel *textLab;

@property (nonatomic, strong) UIImageView *imageView ;

@property (nonatomic, strong) UIButton *actionBtn ;

@property (nonatomic, copy)QGRepaymentBackgroundTouchBlock actionBlock;

@end

@implementation QGRepaymentBackgroundView

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.backgroundColor = [UIColor whiteColor];
        [self setups];
    }
    return self;
}

- (void)setups
{
    UIImageView *imageView  =[UIImageView creatImageViewWithSuperView:self imageName:@"repayment_empty_nomal"];
    [imageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self);
        make.top.equalTo(self).inset(88);
        make.height.width.mas_equalTo(200);
    }];
    self.imageView = imageView;
    
    self.textLab = [UILabel creatLabelWithSuperView:self title:@"暂无账单" titleFontSize:[UIFont qg_lightFontOfSize:14.0f] textColor:[UIColor textColor6666] alignment:NSTextAlignmentCenter];
    self.textLab.numberOfLines = 0;
    
    [self.textLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(imageView);
        make.left.right.equalTo(self).inset(40);
        make.top.equalTo(imageView.mas_bottom).offset(8);
    }];
    
    UIButton *actionBtn = [UIButton creatButtonWithSuperView:self title:@"去还款" titleFont:[UIFont qg_lightFontOfSize:12.0f] textColor:[UIColor mainThemeColor]];
    
    [actionBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.textLab);
        make.top.equalTo(self.textLab.mas_bottom).offset(10);
        make.width.mas_equalTo(100);
        make.height.mas_equalTo(24);
    }];
    actionBtn.layer.borderColor = [UIColor mainThemeColor].CGColor;
    actionBtn.layer.borderWidth = 1;
    actionBtn.layer.cornerRadius = 12;
    actionBtn.layer.masksToBounds = YES;
    actionBtn.hidden = YES;
    self.actionBtn = actionBtn;
    [actionBtn addTarget:self action:@selector(btnAction:) forControlEvents:UIControlEventTouchUpInside];
    
}

- (void)btnAction:(UIButton *)btn
{
    if (self.actionBlock) {
        self.actionBlock();
    }
}

- (void)setImage:(UIImage *)image
           title:(NSString *)title
    hiddenAction:(BOOL)hidden
     actionTitle:(NSString *)actionTitle
     actionBlock:(QGRepaymentBackgroundTouchBlock)actionBlock;
{
    if (image) {
        self.imageView.image = image;
    }
    if (title) {
        self.textLab.text = title;
    }
    self.actionBtn.hidden = hidden;
    if (actionTitle) {
        [self.actionBtn setTitle:actionTitle forState:UIControlStateNormal];
    }
    if (actionBlock) {
        self.actionBlock = actionBlock;
    }
}


/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
