//
//  QGRepayGradientView.m
//  VirtualPayment
//
//  Created by silicn on 2019/6/21.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGRepayGradientView.h"

#import "UIColor+QGColor.h"



@implementation QGRepayGradientView

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.backgroundColor = [UIColor clearColor];
        self.alpha = 0.5;
    }
    return self;
}

- (void)layoutSubviews
{
    [super layoutSubviews];

    self.gradientLayer.frame = self.bounds;
}

- (CAGradientLayer *)gradientLayer
{
    if (!_gradientLayer) {
        _gradientLayer = [CAGradientLayer layer];
        _gradientLayer.startPoint = CGPointMake(0.5, 0);
        _gradientLayer.endPoint = CGPointMake(0.5, 1);
        _gradientLayer.colors = @[(id)[UIColor colorWithHexString:@"E25450" alpha:0.5].CGColor,(id)[UIColor whiteColor].CGColor];
        [self.layer insertSublayer:_gradientLayer atIndex:0];
    }
    return _gradientLayer;
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
