//
//  QGBlurEffectView.m
//  VirtualPayment
//
//  Created by silicn on 2019/6/21.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGBlurEffectView.h"

@interface QGBlurEffectView ()

@property (nonatomic, strong)UIVisualEffectView *effectView;


@end

@implementation QGBlurEffectView

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setupBlurEffect];
        
        UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(tap:)];
        [self addGestureRecognizer:tap];
        
        //这个手势只有一个目的，就是阻挡tableView的滑动手势，这个视图出现后，tableView不能滑动
        UIPanGestureRecognizer *pan = [[UIPanGestureRecognizer alloc]initWithTarget:self action:@selector(pan)];
        [self addGestureRecognizer:pan];
        
    }
    return self;
}

- (void)pan
{
    
}

- (void)tap:(UITapGestureRecognizer *)tap
{
    if (self.tapBlock) {
        self.tapBlock();
    }
}

- (void)layoutSubviews
{
    [super layoutSubviews];
    self.effectView.frame = self.bounds;
}

- (void)setupBlurEffect
{
    UIBlurEffect *blur = [UIBlurEffect effectWithStyle:UIBlurEffectStyleExtraLight];
    self.effectView = [[UIVisualEffectView alloc]initWithEffect:blur];
    _effectView.frame = self.bounds;
    _effectView.alpha = 0.75;
    [self addSubview:_effectView];
}

- (void)showWithDuration:(CGFloat)duration
{
    self.hidden = NO;
    [UIView animateWithDuration:duration animations:^{
        self.alpha = 1.0f;
    }];
}

- (void)hiddenWithDuration:(CGFloat)duration
{
    [UIView animateWithDuration:duration animations:^{
        self.alpha = 0.0f;
    } completion:^(BOOL finished) {
        self.hidden = YES;
    }];
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
