//
//  QGRepaymentAmortizeOrderModel.h
//  VirtualPayment
//
//  Created by silicn on 2019/6/25.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGBaseModel.h"

NS_ASSUME_NONNULL_BEGIN

@interface QGRepaymentAmortizeOrderModel : QGBaseModel

///订单No
@property (nonatomic, copy) NSString *orderNo ;
///订单名称
@property (nonatomic, copy) NSString *orderName ;
///订单金额
@property (nonatomic, copy) NSString *orderAmount ;
///订单发生日期
@property (nonatomic, assign) double orderTime ;
///订单类型-消费/分期
@property (nonatomic, assign) NSInteger orderType ;
/// 是否提前还款
@property (nonatomic, assign) BOOL preRepayType;
///当期期数
@property (nonatomic, assign) NSInteger currTerm ;
///总期数
@property (nonatomic, assign) NSInteger term;
///分期类型-0账单1订单
@property (nonatomic, assign) NSInteger installmentType ;
/// 已优惠金额
@property (nonatomic, copy) NSString *couponInfo ;

/// 退货展示
@property (nonatomic, copy) NSString *refundFlag ;

///分期url
@property (nonatomic, copy) NSString *installmentUrl ;
///订单url
@property (nonatomic, copy) NSString *orderUrl ;
///0-正常 1-已退货 2-有退货
@property (nonatomic, assign) NSInteger status;


@end

NS_ASSUME_NONNULL_END
