//
//  QGShouldAmountViewController.m
//  VirtualPayment
//
//  Created by 张博 on 2019/9/29.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGShouldAmountViewController.h"

//Model
#import "QGRepaymentBillModel.h"

//View
#import "QGShouldAmountHeaderCell.h"
#import "QGShouldAmountCenterCell.h"
#import "QGAmountDescPopView.h"
@interface QGShouldAmountViewController ()


@property (nonatomic, strong) QGRepaymentBillModel *billModel;

/// 标题
@property (nonatomic, strong) NSArray * titleArray;
@end

@implementation QGShouldAmountViewController

- (BOOL)checkParameters:(NSDictionary *)param
{
    QGRepaymentBillModel *billModel = param[@"billModel"];
    if (billModel && [billModel isKindOfClass:[QGRepaymentBillModel class]]) {
        return YES;
    }
    return NO;
}

- (void)transferParameters:(NSDictionary *)param
{
     self.billModel = param[@"billModel"];
}


- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    self.title = @"还款详情";
    [self custemLeftDefaultBarButtonItem];
    self.tableView.backgroundColor = [UIColor moduleSeparatorColorF7F7];
    
    //没有逾期费，则不展示逾期费一行
    if (self.billModel.repayAmountDetail.overdueFee.floatValue == 0) {
         self.titleArray = @[@"本金",@"手续费"];
    }
    else
    {
         self.titleArray = @[@"本金",@"手续费",@"逾期费"];
    }
   
    
}

#pragma mark - UITableViewDataSource

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 2;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    NSInteger numberOfRows = 0;
    switch (section) {
        case 0:
            numberOfRows = 1;
            break;
        case 1:
            numberOfRows = self.titleArray.count;
        break;
            
        default:
            break;
    }
    return numberOfRows;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    
    switch (indexPath.section) {
        case 0:
        {
            QGShouldAmountHeaderCell * cell = (QGShouldAmountHeaderCell *)[self getCellFromClassName:NSStringFromClass([QGShouldAmountHeaderCell class]) dequeueTableView:tableView];
            cell.shouldAmountLabel.text = [NSString stringWithFormat:@"%.2f",self.billModel.balanceAmount.floatValue];
            return cell;
        }
            break;
            //金额展示区
        case 1:
        {
            NSString * titleStr = self.titleArray[indexPath.row];
            QGShouldAmountCenterCell * cell = (QGShouldAmountCenterCell *)[self getCellFromClassName:NSStringFromClass([QGShouldAmountCenterCell class]) dequeueTableView:tableView];
            cell.titleLabel.text = titleStr;
            
            //金额展示区域
            if ([titleStr isEqualToString:@"本金"]) {
                cell.amountLabel.text = [NSString stringWithFormat:@"%.2f元",self.billModel.repayAmountDetail.perTermAmount.floatValue];
                cell.arrowHide = YES;
            }
            else if ([titleStr isEqualToString:@"手续费"])
            {
                cell.amountLabel.text = [NSString stringWithFormat:@"%.2f",self.billModel.repayAmountDetail.perTermFee.floatValue];
                cell.arrowHide = NO;
            }
            else if ([titleStr isEqualToString:@"逾期费"])
            {
                cell.amountLabel.text = [NSString stringWithFormat:@"%.2f",self.billModel.repayAmountDetail.overdueFee.floatValue];
                cell.arrowHide = NO;
            }
            
            
            return cell;
        }
            break;
            
        default:
            break;
    }
    
    return [super tableView:tableView cellForRowAtIndexPath:indexPath];
}


#pragma mark - UITableViewDelegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.section == 1) {
        NSString * titleStr = self.titleArray[indexPath.row];
        //金额展示区域
       if ([titleStr isEqualToString:@"手续费"])
       {
           [QGAmountDescPopView showAmountDescVewWithAmountTitle:@"手续费用详情" amount:self.billModel.repayAmountDetail.perTermFee amountDesc:self.billModel.repayAmountDetail.perTermFeeDesc];
       }
       else if ([titleStr isEqualToString:@"逾期费"])
       {
          [QGAmountDescPopView showAmountDescVewWithAmountTitle:@"逾期费用详情" amount:self.billModel.repayAmountDetail.overdueFee amountDesc:self.billModel.repayAmountDetail.overdueFeeDesc];
       }
    }
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CGFloat heightForRow = 0;
    switch (indexPath.section) {
        case 0:
            heightForRow = 183;
            break;
        case 1:
            heightForRow = 60;
        break;
            
        default:
            break;
    }
    return heightForRow;
}



@end
